# Copyright (C) @BABOLO  2003 Jan 15 http://www.babolo.ru/
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: common.make,v 1.28 2010/02/26 01:56:44 babolo Exp $

#######################################################################################################
.if !target(subdir)
subdir:
. for I in ${SUBDIR}
	@(cd ${I};\
          ${MAKE} ${MAKEFLAGS} CFLAGSPLUS="${CFLAGSPLUS}" PREFIX="${PREFIX}"\
                  PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"\
                  CONFDIR="${CONFDIR}"  LIBEDIR=${LIBEDIR} ROOTDATA="${ROOTDATA}"\
                  all\
        )
. endfor
.endif

.if !target(supdir)
supdir:
. for I in ${SUPDIR}
	@(cd ${I};\
          ${MAKE} ${MAKEFLAGS} CFLAGSPLUS="${CFLAGSPLUS}" PREFIX="${PREFIX}"\
                  PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"\
                  CONFDIR="${CONFDIR}"  LIBEDIR=${LIBEDIR} ROOTDATA="${ROOTDATA}"\
                  all\
        )
. endfor
.endif

#######################################################################################################

.for I in ${SGEN}
. if !target(${I})
${I}: ${MAKEINC} Makefile ${M4INC} def.m4 ${I}.m4
	${M4} ${M4FLAGS} -DPKG=${PKG} -DVMAJOR=${VMAJOR} -DVERS=${VERS}\
              -DLIBEDIR=${LIBEDIR} -DBINOVER=${BINOVER} -DBINDIR=${BINDIR} -DDATADIR=${DATADIR}\
              -DCAT=${CAT} -DSED=${SED} -DGREP=${GREP} -DAWK=${AWK}\
             ${M4INC} def.m4 ${I}.m4 > ${I}
. endif
.endfor

.m4: ${MAKEINC} Makefile ${M4INC} def.m4 ${.IMPSRC}
	${M4} ${M4FLAGS} -DPKG=${PKG} -DVMAJOR=${VMAJOR} -DVERS=${VERS}\
              -DLIBEDIR=${LIBEDIR} -DBINOVER=${BINOVER} -DBINDIR=${BINDIR} -DDATADIR=${DATADIR}\
              -DCAT=${CAT} -DSED=${SED} -DGREP=${GREP} -DAWK=${AWK}\
             ${M4INC} def.m4 ${.IMPSRC} > ${.TARGET}

# ,    ,    

.for I in ${MGEN}
. if !target(${I})
${I}: ${MAKEINC} Makefile ${M4INC} def.m4 ${I}.m4
	${M4} ${M4FLAGS} -DPKG=${PKG} -DVMAJOR=${VMAJOR} -DVERS=${VERS}\
              -DLIBEDIR=${LIBEDIR} -DBINOVER=${BINOVER} -DBINDIR=${BINDIR} -DDATADIR=${DATADIR}\
              -DCAT=${CAT} -DSED=${SED} -DGREP=${GREP} -DAWK=${AWK}\
             ${M4INC} def.m4 ${I}.m4 > ${I}
. endif
.endfor

.cgm4.cgi: ${MAKEINC} Makefile ${M4INC} def.m4 ${.IMPSRC} ${LIBINCLUDEDIR}/pgocgi.m4
	${M4} ${M4FLAGS} -DPKG=${PKG} -DVMAJOR=${VMAJOR} -DVERS=${VERS}\
              -DLIBEDIR=${LIBEDIR} -DBINOVER=${BINOVER} -DBINDIR=${BINDIR} -DDATADIR=${DATADIR}\
              -DCAT=${CAT} -DSED=${SED} -DGREP=${GREP} -DAWK=${AWK}\
             ${M4INC} ${LIBINCLUDEDIR}/pgocgi.m4 def.m4 ${.IMPSRC} > ${.TARGET}

#######################################################################################################

.for I in ${MANS1} ${MANS3} ${MANS5} ${MANS8}
. if !target(${I}.gz)
${I}.gz: Makefile ${I}
	${GZIP} -cn ${I} > ${I}.gz
. endif
.endfor

.for I in ${PGMOD}
. if !target(${I}.so.${VMAJOR})
${I}.so.${VMAJOR}: Makefile ${I}.c
	${CC} ${CFLAGS} -f${FPIC} -shared -I${PG_INCLDIR_SRV} -I${INCLUDEDIR} -o ${I}.so.${VMAJOR} ${I}.c
. endif
.endfor

.undef J
.for I in ${SHLIB}
   J		+= ${I}.o

${I}.o:	Makefile ${INCH} ${I}.c
	${CC} ${CFLAGS} -f${FPIC} -c ${I}.c

.endfor
.if !target(${SHLIBVNAME})
${SHLIBVNAME}: Makefile ${J}
	${CC} ${CFLAGS} -f${FPIC} -shared -Wl,-h${SHLIBVNAME} -o ${SHLIBVNAME} ${J}
.endif

.c.o: Makefile ${INCH}
	${CC} ${CFLAGS} -c ${.IMPSRC}

.if !target(${SHLIBNAME})
${SHLIBNAME}: Makefile ${SHLIBVNAME}
	${LN} -s ${SHLIBVNAME} ${SHLIBNAME}
.endif

.undef J
.for I in ${STLIB}
  J		+= ${I}.o
.endfor
.if !target(${STLIBNAME})
${STLIBNAME}: Makefile ${J}
	${AR} cru ${STLIBNAME} ${J}
	${RANLIB} ${STLIBNAME}
.endif

.for I in ${PROG}
. if !target(${I})
${I}: Makefile ${OBJS} ${I}.o ${INCH}
.  if defined(DOSHLIB)
	${CC} ${LDFLAGS} ${I}.o ${SHLIBVNAME} -o ${I}
.  elif defined(DOSTLIB)
	${CC} ${LDFLAGS} ${I}.o ${STLIBNAME} -o ${I}
.  else
	${CC} ${LDFLAGS} ${I}.o ${OBJS} -o ${I}
.  endif
. endif
.endfor

#######################################################################################################
.if !target(doclean)
doclean:
	${RM} -f *.o *.core .depend *.bak *.gz ${CLEAN}
. for I in ${SUBDIR} ${SUPDIR}
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} PKG="${PKG}" RM="${RM}" MAKE="${MAKE}" VMAJOR="${VMAJOR}" clean)
. endfor
.endif

#######################################################################################################
.if !target(doinstall)
doinstall:
. if defined(DOSHLIB)
	${MKDIR} -p ${LIBODIR}
	${INSTALL_DATA} ${SHLIBVNAME} ${LIBODIR}
	${RM} -f ${LIBODIR}/${SHLIBNAME}
	${LN} -s ${SHLIBVNAME} ${LIBODIR}/${SHLIBNAME}
	${LDCONFIG} -elf -m ${LIBODIR}
. endif
. if defined(STLIB)
	${MKDIR} -p ${LIBODIR}
	${INSTALL_DATA} ${STLIBNAME} ${LIBODIR}
. endif
. if defined(INCH)
	${MKDIR} -p ${FORINCLUDEDIR}
	${INSTALL_DATA} ${INCH} ${FORINCLUDEDIR}
. endif
. if defined(PROG)
.  if defined(BINOVER)
	${MKDIR} -p ${BINOVER}
.   for I in ${PROG}
	${INSTALL_PROGRAM} ${I} ${BINOVER}/${I}
.   endfor
.  else
	${MKDIR} -p ${BINDIR}
.   for I in ${PROG}
	${INSTALL_PROGRAM} ${I} ${BINDIR}/${I}
.   endfor
.  endif
. endif
. if defined(SCRIPTS)
.  if defined(BINOVER)
	${MKDIR} -p ${BINOVER}
.   for I in ${SCRIPTS}
.    if defined(SCRIPTFILTER)
	${SED} ${SCRIPTFILTER} ${I} > ${BINOVER}/${I}
	${CHOWN} ${CHOWNER} ${BINOVER}/${I}
	${CHMOD} ${BINMODE} ${BINOVER}/${I}
.    else
	${INSTALL_SCRIPT} ${I} ${BINOVER}/${I}
.    endif
.   endfor
.  else
	${MKDIR} -p ${BINDIR}
.   for I in ${SCRIPTS}
.    if defined(SCRIPTFILTER)
	${SED} ${SCRIPTFILTER} ${I} > ${BINDIR}/${I}
	${CHOWN} ${CHOWNER} ${BINDIR}/${I}
	${CHMOD} ${BINMODE} ${BINDIR}/${I}
.    else
	${INSTALL_SCRIPT} ${I} ${BINDIR}/${I}
.    endif
.   endfor
.  endif
. endif
. if defined(PGMOD)
	${MKDIR} -p ${PG_MODULEDIR}
.  for I in ${PGMOD}
	${INSTALL_DATA} ${I}.so.${VMAJOR} ${PG_MODULEDIR}/${I}.so.${VMAJOR}
.  endfor
. endif
. if defined(MANZ1)
	${MKDIR} -p ${MAN1DIR}
.  for I in ${MANZ1}
	${INSTALL_MAN} ${I} ${MAN1DIR}/${I}
.  endfor
. endif
. if defined(MANZ3)
	${MKDIR} -p ${MAN3DIR}
.  for I in ${MANZ3}
	${INSTALL_MAN} ${I} ${MAN3DIR}/${I}
.  endfor
. endif
. if defined(MAN3)
	${MKDIR} -p ${MAN3DIR}
.  for I in ${MAN3}
	${LN} -f ${MAN3DIR}/${PKG}.3.gz ${MAN3DIR}/${I}.3.gz
.  endfor
. endif
. if defined(MANZ5)
	${MKDIR} -p ${MAN5DIR}
.  for I in ${MANZ5}
	${INSTALL_MAN} ${I} ${MAN5DIR}/${I}
.  endfor
. endif
. if defined(MANZ8)
	${MKDIR} -p ${MAN8DIR}
.  for I in ${MANZ8}
	${INSTALL_MAN} ${I} ${MAN8DIR}/${I}
.  endfor
. endif
. if defined(DATADIR)
.  if defined(DATA)
	${MKDIR} -p ${DATADIR}
	${INSTALL_DATA} ${DATA} ${DATADIR}
.  endif
.  if defined(SAMPLE)
	${MKDIR} -p ${DATADIR}
.   for I in ${SAMPLE}
	${INSTALL_DATA} ./${I} ${DATADIR}/${I}.sample
	@if [ ! -e ${DATADIR}/${I} ]; then\
            ${INSTALL_DATA} ./${I} ${DATADIR}/${I};\
        fi
.   endfor
.  endif
. endif
. if defined(CONF)
	${MKDIR} -p ${CONFDIR}
.  for I in ${CONF}
	${RM} -f ${CONFDIR}/${I}.orig
	${SED} ${SCRIPTFILTER} ${I} > ${CONFDIR}/${I}.orig
	${CHOWN} ${CHOWNER} ${CONFDIR}/${I}.orig
	${CHMOD} ${DATAMODE} ${CONFDIR}/${I}.orig
	@if [ ! -e ${CONFDIR}/${I} ]; then\
            ${CP} -p ${CONFDIR}/${I}.orig ${CONFDIR}/${I};\
        elif ! diff -bBdqa ${CONFDIR}/${I} ${CONFDIR}/${I}.orig > /dev/null; then\
            ${ECHO} "";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "********** !!! old             ${CONFDIR}/${I}      **********";\
            ${ECHO} "********** !!! differ from new ${CONFDIR}/${I}.orig **********";\
            ${ECHO} "";\
            diff ${CONFDIR}/${I} ${CONFDIR}/${I}.orig || true;\
            ${ECHO} "";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "";\
        fi
.  endfor
. endif
.endif

.if !target(subdirinstall)
subdirinstall:
. for I in ${SUBDIR}
	@(cd ${I};\
          ${MAKE} ${MAKEFLAGS} CFLAGSPLUS="${CFLAGSPLUS}" PREFIX="${PREFIX}"\
                  PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"\
                  LIBEDIR="${LIBEDIR}" CONFDIR="${CONFDIR}" ROOTDATA="${ROOTDATA}"\
                  BINMODE="${BINMODE}" MANMODE="${MANMODE}" DATAMODE="${DATAMODE}"\
                  INSTALL_PROGRAM="${INSTALL_PROGRAM}"\
                  INSTALL_SCRIPT="${INSTALL_SCRIPT}"\
                  INSTALL_DATA="${INSTALL_DATA}"\
                  INSTALL_MAN="${INSTALL_MAN}"\
                  OWNER="${OWNER}" CHOWNER="${CHOWNER}"\
                  BINDIR="${BINDIR}" MAN1DIR="${MAN1DIR}" MAN8DIR="${MAN8DIR}"\
                  install\
        )
. endfor
.endif

.if !target(supdirinstall)
supdirinstall:
. for I in ${SUPDIR}
	@(cd ${I};\
          ${MAKE} ${MAKEFLAGS} CFLAGSPLUS="${CFLAGSPLUS}" PREFIX="${PREFIX}"\
                  PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"\
                  LIBEDIR="${LIBEDIR}" CONFDIR="${CONFDIR}" ROOTDATA="${ROOTDATA}"\
                  BINMODE="${BINMODE}" MANMODE="${MANMODE}" DATAMODE="${DATAMODE}"\
                  INSTALL_PROGRAM="${INSTALL_PROGRAM}"\
                  INSTALL_SCRIPT="${INSTALL_SCRIPT}"\
                  INSTALL_DATA="${INSTALL_DATA}"\
                  INSTALL_MAN="${INSTALL_MAN}"\
                  OWNER="${OWNER}" CHOWNER="${CHOWNER}"\
                  BINDIR="${BINDIR}" MAN1DIR="${MAN1DIR}" MAN8DIR="${MAN8DIR}"\
                  install\
        )
. endfor
.endif

#######################################################################################################
.if !target(tarball)
tarball:
	${MKDIR} -p ${DISTNM}
	${CP} -p ${DIST} ${DISTNM}/
. for I in ${SUBDIR} ${SUPDIR}
	@(cd ${I}; ${MAKE} PKG="${PKG}" ${MAKEFLAGS} DISTNM="../${DISTNM}/${I}" tarball)
. endfor
. if defined(VMINOR)
	${TAR} -czvf ${DISTNM}.tar.gz ${DISTNM}
	${RM} -rf ${DISTNM}
. endif
.endif

#######################################################################################################
.if !target(release)
release: prerelease dotag dorelease postrelease
.endif

.if !target(dotag)
dotag:
. if defined(VMINOR)
	${CVS} -q up -dP
	${CVS} tag r${VMAJOR}_${VMINOR}
. endif
.endif

.if !target(dorelease)
dorelease: tarball
. for I in ${REMOTE_SRCDIR}
	${SCP} ${DISTNM}.tar.gz ${I}
. endfor
. for I in ${LOCAL_SRCDIR}
	${CP} ${DISTNM}.tar.gz ${I}
. endfor
	${MD5} ${DISTNM}.tar.gz
	${ECHO} "SIZE (${DISTNM}.tar.gz) = "`wc -c < "${DISTNM}.tar.gz"`
.endif

.if !target(rerelease)
rerelease: delrelease release
.endif

.if !target(delrelease)
delrelease:
. if defined(VMINOR)
	${CVS} tag -d r${VMAJOR}_${VMINOR}
. endif
.endif

#######################################################################################################
.if !target(notify)
notify:
. if defined(REQUIRED)
	${BINDIR}/babololib-version ${REQUIRED}
. endif
	@${ECHO} "===> make in ${PKG}:${PWD}"
.endif

.if !target(unnotify)
unnotify:
	@${ECHO} "===> end in ${PKG}:${PWD}"
.endif

.for I in pre post
. for K in all clean install release
.  if !target(${I}${K})
${I}${K}:
.  endif
. endfor
.endfor

.if !target(clean)
clean: notify preclean doclean postclean unnotify
.endif

.if !target(install)
install: notify all preinstall subdirinstall doinstall supdirinstall postinstall unnotify
. if defined(VMINOR)
.  if defined(PROTOVER)
	${ECHO} "${VMAJOR}.${VMINOR}" > "${VERSIONDIR}/${PKG}:${PROTOVER}.VERSION"
.  else
	${ECHO} "${VMAJOR}.${VMINOR}" > "${VERSIONDIR}/${PKG}.VERSION"
.  endif
. endif
.endif

.if !target(all)
all: notify preall Makefile subdir doall doman supdir postall unnotify
.endif

.if !target(doall)
doall: ${SHLIBNAME} ${STLIBNAME} ${PROG} ${MGEN} ${SCRIPTS} ${DATA}
.endif

.if !target(doman)
doman: ${MANZ1} ${MAN3ZRG} ${MANZ3} ${MANZ5} ${MANZ8}
.endif
