/*-
 * Copyright (C)2003 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: BLINflag.h,v 1.10 2010/09/19 18:35:49 babolo Exp $
 */

#ifndef  _BABOLO_BLINflag_H_
# define _BABOLO_BLINflag_H_

__BEGIN_DECLS

typedef u_int32_t BLIN_flag;

/*****************************************************************************************************/
/*                                                                     for use in poins of debugging */
#define BLIN_VER1    0x01000000
#define BLIN_VER2    0x02000000
#define BLIN_VER3    0x04000000
#define BLIN_VER4    0x08000000
#define BLIN_VER5    0x10000000
#define BLIN_VER6    0x20000000
#define BLIN_VER7    0x40000000
#define BLIN_VER8    0x80000000
#define BLIN_VERMASK 0xFF000000

/*****************************************************************************************************/
/*                          for use in contol block. sets by blin_ctl(BLIN_CTL_WHAT, ) 2nd parameter */
#define BLIN_MODWARN  0x800000
#define BLIN_MODPRNT  0x400000
#define BLIN_MODLOGR  0x200000
#define BLIN_MODEOAU  0x040000
#define BLIN_MODEOCR  0x020000
#define BLIN_MODEOLF  0x010000

/*****************************************************************************************************/
/*                                                              for blin_ctl() control 1st parameter */
#define BLIN_CTL_NONE 0x00010000
#define BLIN_CTL_LEV0 0x00000001
#define BLIN_CTL_LEV1 0x00000002
#define BLIN_CTL_LEV2 0x00000004
#define BLIN_CTL_LEV3 0x00000008
#define BLIN_CTL_LEV4 0x00000010
#define BLIN_CTL_LEV5 0x00000020
#define BLIN_CTL_LEV6 0x00000040
#define BLIN_CTL_LEV7 0x00000080
#define BLIN_CTL_LEVM 0x000000FF
#define BLIN_CTL_FSET 0x00000001
#define BLIN_CTL_FRST 0x00000002
#define BLIN_CTL_WHAT 0x00000100
#define BLIN_CTL_FILE 0x00000200
#define BLIN_CTL_PRIO 0x00000300
#define BLIN_CTL_OPER 0x00000F00

/*****************************************************************************************************/
/*                                                                               BLIN infrastructure */
/*#define ifBLIN_FLAG extern blin_pamparam blin_pamparam_internal; u_int32_t blin_internal_flags*/
#define ifBLIN_FLAG u_int32_t blin_internal_flags

typedef struct blin_pamparam {
    u_int32_t flags;
    u_int32_t dummy;
    struct {
        FILE     *file;
        u_int32_t what;
        int       prio;
    } w[8];
} blin_pamparam;

/*****************************************************************************************************/
/*                                        old style poins of debugging. have to be deleted sometimes */
#define ifBLIN_QV1(flag) if ((flag) & BLIN_VER1)
#define ifBLIN_QV2(flag) if ((flag) & BLIN_VER2)
#define ifBLIN_QV3(flag) if ((flag) & BLIN_VER3)
#define ifBLIN_QV4(flag) if ((flag) & BLIN_VER4)
#define ifBLIN_QV5(flag) if ((flag) & BLIN_VER5)
#define ifBLIN_QV6(flag) if ((flag) & BLIN_VER6)
#define ifBLIN_QV7(flag) if ((flag) & BLIN_VER7)
#define ifBLIN_QV8(flag) if ((flag) & BLIN_VER8)

/*****************************************************************************************************/
/*                                                                      new style poins of debugging */
#define ifBLIN_QU0(FLAGS, F, ...) ifBLIN_TEMPLATE(FLAGS & BLIN_VER1, 0, F, ## __VA_ARGS__);
#define ifBLIN_QU1(FLAGS, F, ...) ifBLIN_TEMPLATE(FLAGS & BLIN_VER2, 1, F, ## __VA_ARGS__);
#define ifBLIN_QU2(FLAGS, F, ...) ifBLIN_TEMPLATE(FLAGS & BLIN_VER3, 2, F, ## __VA_ARGS__);
#define ifBLIN_QU3(FLAGS, F, ...) ifBLIN_TEMPLATE(FLAGS & BLIN_VER4, 3, F, ## __VA_ARGS__);
#define ifBLIN_QU4(FLAGS, F, ...) ifBLIN_TEMPLATE(FLAGS & BLIN_VER5, 4, F, ## __VA_ARGS__);
#define ifBLIN_QU5(FLAGS, F, ...) ifBLIN_TEMPLATE(FLAGS & BLIN_VER6, 5, F, ## __VA_ARGS__);
#define ifBLIN_QU6(FLAGS, F, ...) ifBLIN_TEMPLATE(FLAGS & BLIN_VER7, 6, F, ## __VA_ARGS__);
#define ifBLIN_QU7(FLAGS, F, ...) ifBLIN_TEMPLATE(FLAGS & BLIN_VER8, 7, F, ## __VA_ARGS__);
#define ifBLIN_QX0(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER1, 0, F, ## __VA_ARGS__);
#define ifBLIN_QX1(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER2, 1, F, ## __VA_ARGS__);
#define ifBLIN_QX2(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER3, 2, F, ## __VA_ARGS__);
#define ifBLIN_QX3(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER4, 3, F, ## __VA_ARGS__);
#define ifBLIN_QX4(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER5, 4, F, ## __VA_ARGS__);
#define ifBLIN_QX5(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER6, 5, F, ## __VA_ARGS__);
#define ifBLIN_QX6(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER7, 6, F, ## __VA_ARGS__);
#define ifBLIN_QX7(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER8, 7, F, ## __VA_ARGS__);
#define ifBLIN_QW0(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER1, 8, F, ## __VA_ARGS__);
#define ifBLIN_QW1(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER2, 9, F, ## __VA_ARGS__);
#define ifBLIN_QW2(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER3, 10, F, ## __VA_ARGS__);
#define ifBLIN_QW3(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER4, 11, F, ## __VA_ARGS__);
#define ifBLIN_QW4(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER5, 12, F, ## __VA_ARGS__);
#define ifBLIN_QW5(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER6, 13, F, ## __VA_ARGS__);
#define ifBLIN_QW6(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER7, 14, F, ## __VA_ARGS__);
#define ifBLIN_QW7(F, ...) ifBLIN_TEMPLATE(blin_internal_flags & BLIN_VER8, 15, F, ## __VA_ARGS__);

#define ifBLIN_TEMPLATE(FLAGS, LEVEL, FORMAT, ...)                                                    \
    do {if (FLAGS) blin_cry1(LEVEL, FORMAT, ## __VA_ARGS__);                                          \
    } while (0)

/*****************************************************************************************************/
/*                                                                                   BLIN procedures */
void           *blin_ctl       __P((int mode, ...));
int             blin_cry1      __P((int mode, const char *format, ...));

/*****************************************************************************************************/
/*                                                                          to manipulate BLIN flags */
#define BLIN_VERBOSE(flag) {(flag) |= ((((flag) << 1) & BLIN_VERMASK) | BLIN_VER1);}
#define kukBLIN_VERMASK(x) (((u_int32_t)(x) << 24) & BLIN_VERMASK)
#define setBLIN_VERMASK(flag,x) {(flag) &= ~BLIN_VERMASK; (flag) |= kukBLIN_VERMASK(x);}
#define getBLIN_VERMASK(flag) (((flag) >> 24) & (BLIN_VERMASK >> 24))

/*****************************************************************************************************/
/*                                          for use in printf of pointers on both 32 and 64 bit arch */
#ifdef __amd64__
# define BLIN_U    "lu"
# define BLIN_X    "012lX"
# define BLIN_I(P) ((u_int64_t)(P))
#else
# define BLIN_U    "u"
# define BLIN_X    "08X"
# define BLIN_I(P) ((u_int32_t)(P))
#endif

/*****************************************************************************************************/
/*                                                                  for hard state mashine debugging */
# ifdef ALLIGN_TABLE

#define BLIN_STATEHEADER(f, n) \
{   int BLIN_STATEVAR_i;                                                                              \
    fprintf((f), "control-");                                                                         \
    for (BLIN_STATEVAR_i = 0; BLIN_STATEVAR_i < 24; BLIN_STATEVAR_i++)                                \
        if  ((n)[BLIN_STATEVAR_i][0] != '-') fprintf((f), "-%s", (n)[BLIN_STATEVAR_i]);               \
    fprintf((f), "nst vl cl st     p    --- q ---\n");                                                \
}

#define BLIN_STATEBODY(f, n, r, cn, in, q, p, c, sn, s, C, e) \
{   int BLIN_STATEVAR_i, BLIN_STATEVAR_j, BLIN_STATEVAR_k;                                            \
    fprintf((f), "%08X ", (c));                                                                       \
    for ( BLIN_STATEVAR_i = 0, BLIN_STATEVAR_j = (c), BLIN_STATEVAR_k = 0                             \
        ; BLIN_STATEVAR_i < 24                                                                        \
        ; BLIN_STATEVAR_i++, BLIN_STATEVAR_j <<= 1                                                    \
        )                                                                                             \
        if  (((n)[BLIN_STATEVAR_i][0] != '-') || (BLIN_STATEVAR_j & 0x80000000))                      \
            fprintf( (f), "%s "                                                                       \
                   , (BLIN_STATEVAR_j & 0x80000000) ? (n)[BLIN_STATEVAR_i] : (u_char*)"  "            \
                   );                                                                                 \
    fprintf( (f), "%s %02X %s %s %08X %" BLIN_X "\t~"                                                 \
           , (sn)[(c) & (C)], (u_int)(r), (cn), (sn)[(s)], BLIN_I(p), (u_int)(q)                      \
           );                                                                                         \
    for ( BLIN_STATEVAR_i = 0; (in)[(q) + BLIN_STATEVAR_i] && (e); BLIN_STATEVAR_i++)                 \
        fprintf((f), "%c", (in)[(q) + BLIN_STATEVAR_i]);                                              \
    fprintf((f), "~\n");                                                                              \
}

# else

#define BLIN_STATEHEADER(f, n) \
{   fprintf((f), "-------- control ------nst rs cl st     p    --- q ---\n");}

#define BLIN_STATEBODY(f, n, r, cn, in, q, p, c, sn, s, C, e) \
{   int BLIN_STATEVAR_i, BLIN_STATEVAR_j, BLIN_STATEVAR_k;                                            \
    fprintf((f), "%08X ", (c));                                                                       \
    for ( BLIN_STATEVAR_i = 0, BLIN_STATEVAR_j = (c), BLIN_STATEVAR_k = 0                             \
        ; BLIN_STATEVAR_i < 24                                                                        \
        ; BLIN_STATEVAR_i++, BLIN_STATEVAR_j <<= 1                                                    \
        )                                                                                             \
        if  (BLIN_STATEVAR_j & 0x80000000) {                                                          \
            fprintf((f), "%s ", (n)[BLIN_STATEVAR_i]);                                                \
            BLIN_STATEVAR_k++;                                                                        \
        };                                                                                            \
    for (; BLIN_STATEVAR_k < 5; BLIN_STATEVAR_k++) fprintf((f), "   ");                               \
    fprintf((f), "%s %02X %s %s %08X %08X\t~", (sn)[(c) & (C)], (r), (cn), (sn)[(s)], (p), (q));      \
    for (BLIN_STATEVAR_i = 0; (in)[(q) + BLIN_STATEVAR_i] && (e); BLIN_STATEVAR_i++)                  \
        fprintf((f), "%c", (in)[(q) + BLIN_STATEVAR_i]);                                              \
    fprintf((f), "~\n");                                                                              \
}

# endif

__END_DECLS

#endif /* _BABOLO_BLINflag_H_ */
