# Copyright (C) @BABOLO  2003 Jan 15
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: define.make,v 1.8 2004/10/16 07:01:14 babolo Exp $

.if defined(BASE)
. if defined(MODULE)
LIBEDIR		?= ${PREFIX}/libexec/${BASE}/${MODULE}${SUBMODULE}
. else
LIBEDIR		?= ${PREFIX}/libexec/${BASE}
. endif
DATADIR		?= ${LIBEDIR}
GENCLASS	?= ${MODULE}
PKG		?= ${BASE}-${MODULE}${SUBMODULE}
.endif

.if defined(VMINOR)
 VERS	= ${VMAJOR}.${VMINOR}
 DISTNM	= ${PKG}-${VERS}
 DATE	!= env LANG= LC_ALL= date +%v | sed -e 's| ||g'
.endif

BINMODE		?= 0555
MANMODE		?= 0444
DATAMODE	?= 0444
OWNER		?= -o root -g wheel
CHOWNER		?= "0:0"
INSTALL_PROGRAM	?= install -c -s ${OWNER} -m ${BINMODE}
INSTALL_SCRIPT	?= install -C ${OWNER} -m ${BINMODE}
INSTALL_DATA	?= install -C ${OWNER} -m ${DATAMODE}
INSTALL_MAN	?= install -C ${OWNER} -m ${MANMODE}
PREFIX		?= /usr/local
BINDIR		?= ${PREFIX}/bin
LIBIDIR		?= ${PREFIX}/lib
LIBODIR		?= ${LIBIDIR}
CONFDIR		?= ${PREFIX}/etc
MAN1DIR		?= ${PREFIX}/man/${MANLANG}/man1
MAN3DIR		?= ${PREFIX}/man/${MANLANG}/man3
MAN5DIR		?= ${PREFIX}/man/${MANLANG}/man5
MAN8DIR		?= ${PREFIX}/man/${MANLANG}/man8
LIBEDIR		?= ${PREFIX}/libexec/${PKG}
INCLUDEDIR	?= ${PREFIX}/include
LIBINCLUDEDIR	?= ${INCLUDEDIR}/babolo
BUILDINCLUDEDIR	?= ${LIBINCLUDEDIR}
WWWROOT		?= ${PREFIX}/www
BABOLOMAKE_CONF	?= ${CONFDIR}/babolomake.conf
AR		?= ar
CP		?= cp
MV		?= mv
RM		?= rm
SH		?= sh
LN		?= ln
M4		?= gm4
CAT		?= cat
SED		?= sed
AWK		?= awk
SCP		?= scp
CVS		?= cvs
MD5		?= md5
PLUSENV		?= env
TAR		?= tar
PWD		?= pwd
GZIP		?= gzip
MAKE		?= make
GREP		?= grep
ECHO		?= echo
MKDIR		?= mkdir
CHOWN		?= chown
CHMOD		?= chmod
TOOLS		?= tools
RANLIB		?= ranlib
LDCONFIG	?= ldconfig
PG_CONFIG	?= pg_config
EXECTMPL	?= ${PLUSENV} ECHO=${ECHO} CAT=${CAT} SED=${SED} GREP=${GREP} SH=${SH} ${SH} -e
POSTGRESRC	?= ${MAKEOBJDIRPREFIX}/usr/ports/databases/postgresql72/work/postgresql-7.2.5
PG_INCLDIR_SRV	!= if ${PG_CONFIG} --includedir-server 2>/dev/null; then fi
PG_MODULEDIR	!= if ${PG_CONFIG} --pkglibdir 2>/dev/null; then fi
PG_SQLIBDIR	?= ${PREFIX}/share/postgresql/contrib

.if !defined(PG_INCLDIR_SRV) || ${PG_INCLDIR_SRV} == ""
    PG_INCLDIR_SRV=${POSTGRESRC}/src/include
.endif

.if !defined(PG_MODULEDIR) || ${PG_MODULEDIR} == ""
    PG_MODULEDIR=${LIBODIR}/postgresql
.endif

CFLAGS		+= ${CFLAGSPLUS} -DVERS=\"${VERS}\" -DDATE=\"${DATE}\" -DPREFIX=\"${PREFIX}\"
MAKEFLAGS	+= -I ${BUILDINCLUDEDIR} BUILDINCLUDEDIR=${BUILDINCLUDEDIR}
MAKEFLAGS	+= -I ${LIBINCLUDEDIR} LIBINCLUDEDIR=${LIBINCLUDEDIR}

.if exists(Shema)
PLUGSQLSCRIPTS	= S_create S_init S_restore S_tune S_dump S_delete
CLEAN		+= ${PLUGSQLSCRIPTS}
.endif
.if defined(MGEN)
CLEAN		+= ${MGEN}
.endif
.if defined(SGEN)
MGEN		+= ${SGEN}
CLEAN		+= ${SGEN}
SCRIPTS		+= ${SGEN}
.endif
MISC		+= Makefile

.if defined(PROG)
. if !defined(SRCS)
.  for I in ${PROG}
    SRCS	+= ${I}.c
.  endfor
. endif
.endif

.for I in ${INCS}
  INCH		+= ${I}.h
.endfor

.for I in ${PROG} ${SCRIPTS}
. if exists(${I}.1)
   MANS1	+= ${I}.1
   MANZ1	+= ${I}.1.gz
. endif
. if exists(${I}.8)
   MANS8	+= ${I}.8
   MANZ8	+= ${I}.8.gz
. endif
.endfor

.if defined(PGMOD)
. for I in ${PGMOD}
    SRCS	+= ${I}.c
. endfor
.endif

.for I in ${CSRC}
  SRCS	+= ${I}.c
  OBJS	+= ${I}.o
.endfor

.for I in ${MAN}
. if exists(${I}.1)
   MANS1	+= ${I}.1
   MANZ1	+= ${I}.1.gz
. endif
. if exists(${I}.3)
   MANS3	+= ${I}.3
   MANZ3	+= ${I}.3.gz
. endif
. if exists(${I}.5)
   MANS5	+= ${I}.5
   MANZ5	+= ${I}.5.gz
. endif
. if exists(${I}.8)
   MANS8	+= ${I}.8
   MANZ8	+= ${I}.8.gz
. endif
.endfor

.for I in ${MAN3}
. if exists(${I}.3)
   MANS3	+= ${I}.3
   MANZ3	+= ${I}.3.gz
. else
   MAN3ZRG	= ${PKG}.3.gz
   MANS3	+= ${I}.3
.  if !defined(MAN3ORG)
    MAN3ORG	= ${PKG}.3
.  endif
.  if !defined(MAN3IRG)
    MAN3IRG	= ${I}.3.gz
.  else
    MANL3	+= ${I}.3.gz
.  endif
. endif
.endfor

.if defined(SCRIPTFILTER)
. if defined(CONFDIR)
   SCRIPTFILTER+= -e 's|%%CONFDIR%%|${CONFDIR}|g'
. endif
. if defined(LIBEDIR)
   SCRIPTFILTER+= -e 's|%%LIBEDIR%%|${LIBEDIR}|g'
. endif
. if defined(BINDIR)
   SCRIPTFILTER+= -e 's|%%BINDIR%%|${BINDIR}|g'
. endif
. if defined(PREFIX)
   SCRIPTFILTER+= -e 's|%%PREFIX%%|${PREFIX}|g'
. endif
. if defined(WWWROOT)
   SCRIPTFILTER+= -e 's|%%WWWROOT%%|${WWWROOT}|g'
. endif
. if defined(WWWROOTDATA)
   SCRIPTFILTER+= -e 's|%%WWWROOTDATA%%|${WWWROOTDATA}|g'
. endif
.endif

.if exists(${BABOLOMAKE_CONF})
. include <${BABOLOMAKE_CONF}>
. if defined(USERMAKE_CONF)
.  if exists(${USERMAKE_CONF})
.   include <${USERMAKE_CONF}>
.  endif
. endif
.endif

.MAIN: all
.SUFFIXES : .sql .4tml .html .shtml .so .so.${MAJOR}

