# Copyright (C) @BABOLO  2003 Jan 15
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $Id: common.make,v 1.14 2004/10/16 07:01:14 babolo Exp $

#######################################################################################################
subdir:
.for I in ${SUBDIR}
	@(cd ${I};\
          ${MAKE} ${MAKEFLAGS} PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"\
                  CFLAGSPLUS="${CFLAGSPLUS}" PREFIX="${PREFIX}"\
                  LIBEDIR=${LIBEDIR} ROOTDATA="${ROOTDATA}"\
                  all\
        )
.endfor

#######################################################################################################

.for I in ${MGEN}
 MISC	+= ${I}.m4
${I}: Makefile ${BUILDINCLUDEDIR}/def.m4 def.m4 ${I}.m4
	${M4} -DBUILDINCLUDEDIR=${BUILDINCLUDEDIR} -DLIBINCLUDEDIR=${LIBINCLUDEDIR}\
              -DLIBEDIR=${LIBEDIR} -DBINOVER=${BINOVER} -DBINDIR=${BINDIR} -DDATADIR=${DATADIR}\
              -DVMAJOR=${VMAJOR} -DCAT=${CAT} -DSED=${SED} -DGREP=${GREP} -DAWK=${AWK}\
             ${BUILDINCLUDEDIR}/def.m4 def.m4 ${I}.m4 > ${I}
.endfor

.for I in ${MANS1} ${MANS3} ${MANS5} ${MANS8}
${I}.gz: Makefile ${I}
	${GZIP} -cn ${I} > ${I}.gz
.endfor

.if defined(MAN3ORG)
${MAN3ZRG}: Makefile ${MAN3ORG}
	${GZIP} -cn ${MAN3ORG} > ${MAN3ZRG}
.endif

.for I in ${PGMOD}
 DATA	+= ${I}.so.${VMAJOR}
${I}.so.${VMAJOR}: Makefile ${I}.c
	${CC} ${CFLAGS} -fpic -shared -I${PG_INCLDIR_SRV} -I${INCLUDEDIR} -o ${I}.so.${VMAJOR} ${I}.c
.endfor

.undef J
.if defined(SHLIB)
. if defined(LIBNAME)
   DOSHLIB	= ${LIBNAME}
. else
   DOSHLIB	= ${PKG}
. endif
   SHLIBNAME	= lib${DOSHLIB}.so
   SHLIBVNAME	= ${SHLIBNAME}.${VMAJOR}
. for I in ${SHLIB}
   J += ${I}.o
. endfor
${SHLIBVNAME}: Makefile ${J}
	${CC} ${CFLAGS} -fpic -shared -o ${SHLIBVNAME} ${J}

${SHLIBNAME}: Makefile ${SHLIBVNAME}
#	${LN} -s ${SHLIBVNAME} ${SHLIBNAME}
.endif

.undef J
.if defined(STLIB)
. if defined(LIBNAME)
   DOSTLIB	+= ${LIBNAME}
. else
   DOSTLIB	+= ${PKG}
. endif
   STLIBNAME	= lib${DOSTLIB}.a
. for I in ${STLIB}
   J += ${I}.o
. endfor
${STLIBNAME}: Makefile ${J}
	${AR} cru ${STLIBNAME} ${J}
	${RANLIB} ${STLIBNAME}
.endif

.for I in ${PROG}
${I}: Makefile ${OBJS} ${I}.o
. if defined(DOSHLIB)
	${CC} ${LDFLAGS} ${I}.o ${SHLIBVNAME} -o ${I}
. elif defined(DOSTLIB)
	${CC} ${LDFLAGS} ${I}.o ${STLIBNAME} -o ${I}
. else
	${CC} ${LDFLAGS} ${OBJS} ${I}.o -o ${I}
. endif
.endfor

#######################################################################################################
doclean:
	${RM} -f *.o *.so *.so.${VMAJOR} ${STLIBNAME} *.core .depend *.bak ${PROG} *.gz index.dir *.shtml ${CLEAN}
.if defined(TITLE)
	${RM} -f index.4tml
.endif
.for I in ${SUBDIR}
	@(cd ${I}; ${MAKE} ${MAKEFLAGS} PKG="${PKG}" RM="${RM}" MAKE="${MAKE}" VMAJOR="${VMAJOR}" clean)
.endfor

#######################################################################################################
doinstall:
.if defined(DOSHLIB)
	${MKDIR} -p ${LIBODIR}
	${INSTALL_DATA} ${SHLIBVNAME} ${LIBODIR}
	${RM} -f ${LIBODIR}/${SHLIBNAME}
	${LN} -s ${SHLIBVNAME} ${LIBODIR}/${SHLIBNAME}
	${LDCONFIG} -elf -m ${LIBODIR}
.endif
.if defined(STLIB)
	${MKDIR} -p ${LIBODIR}
	${INSTALL_DATA} ${STLIBNAME} ${LIBODIR}
.endif
.if defined(INCH)
	${MKDIR} -p ${INCLUDEDIR}
	${INSTALL_DATA} ${INCH} ${INCLUDEDIR}
.endif
.if defined(PROG)
. if defined(BINOVER)
	${MKDIR} -p ${BINOVER}
.  for I in ${PROG}
	${INSTALL_PROGRAM} ${I} ${BINOVER}/${I}
.  endfor
. else
	${MKDIR} -p ${BINDIR}
.  for I in ${PROG}
	${INSTALL_PROGRAM} ${I} ${BINDIR}/${I}
.  endfor
. endif
.endif
.if defined(SCRIPTS)
. if defined(BINOVER)
	${MKDIR} -p ${BINOVER}
.  for I in ${SCRIPTS}
.   if defined(SCRIPTFILTER)
	${SED} ${SCRIPTFILTER} ${I} > ${BINOVER}/${I}
	${CHOWN} ${CHOWNER} ${BINOVER}/${I}
	${CHMOD} ${BINMODE} ${BINOVER}/${I}
.   else
	${INSTALL_SCRIPT} ${I} ${BINOVER}/${I}
.   endif
.  endfor
. else
	${MKDIR} -p ${BINDIR}
.  for I in ${SCRIPTS}
.   if defined(SCRIPTFILTER)
	${SED} ${SCRIPTFILTER} ${I} > ${BINDIR}/${I}
	${CHOWN} ${CHOWNER} ${BINDIR}/${I}
	${CHMOD} ${BINMODE} ${BINDIR}/${I}
.   else
	${INSTALL_SCRIPT} ${I} ${BINDIR}/${I}
.   endif
.  endfor
. endif
.endif
.if defined(PGMOD)
	${MKDIR} -p ${PG_MODULEDIR}
. for I in ${PGMOD}
	${INSTALL_DATA} ${I}.so.${VMAJOR} ${PG_MODULEDIR}/${I}.so.${VMAJOR}
. endfor
.endif
.if defined(MANZ1)
	${MKDIR} -p ${MAN1DIR}
. for I in ${MANZ1}
	${INSTALL_MAN} ${I} ${MAN1DIR}/${I}
. endfor
.endif
.if defined(MANZ3)
	${MKDIR} -p ${MAN3DIR}
. for I in ${MANZ3}
	${INSTALL_MAN} ${I} ${MAN3DIR}/${I}
. endfor
.endif
.if defined(MAN3IRG)
	${MKDIR} -p ${MAN3DIR}
	${INSTALL_MAN} ${MAN3ZRG} ${MAN3DIR}/${MAN3IRG}
. for I in ${MANL3}
	${LN} -f ${MAN3DIR}/${MAN3IRG} ${MAN3DIR}/${I}
. endfor
.endif
.if defined(MANZ5)
	${MKDIR} -p ${MAN5DIR}
. for I in ${MANZ5}
	${INSTALL_MAN} ${I} ${MAN5DIR}/${I}
. endfor
.endif
.if defined(MANZ8)
	${MKDIR} -p ${MAN8DIR}
. for I in ${MANZ8}
	${INSTALL_MAN} ${I} ${MAN8DIR}/${I}
. endfor
.endif
.if defined(DATADIR)
. if defined(DATA)
	${MKDIR} -p ${DATADIR}
	${INSTALL_DATA} ${DATA} ${DATADIR}
. endif
. if defined(SAMPLE)
	${MKDIR} -p ${DATADIR}
.  for I in ${SAMPLE}
	${INSTALL_DATA} ./${I} ${DATADIR}/${I}.sample
	@if [ ! -e ${DATADIR}/${I} ]; then\
            ${INSTALL_DATA} ./${I} ${DATADIR}/${I};\
        fi
.  endfor
. endif
.endif
.if defined(CONF)
	${MKDIR} -p ${CONFDIR}
. for I in ${CONF}
	${RM} -f ${CONFDIR}/${I}.orig
	${SED} ${SCRIPTFILTER} ${I} > ${CONFDIR}/${I}.orig
	${CHOWN} ${CHOWNER} ${CONFDIR}/${I}.orig
	${CHMOD} ${DATAMODE} ${CONFDIR}/${I}.orig
	@if [ ! -e ${CONFDIR}/${I} ]; then\
            ${CP} -p ${CONFDIR}/${I}.orig ${CONFDIR}/${I};\
        elif ! diff -bBdqa ${CONFDIR}/${I} ${CONFDIR}/${I}.orig > /dev/null; then\
            ${ECHO} "";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "********** !!! old             ${CONFDIR}/${I}      **********";\
            ${ECHO} "********** !!! differ from new ${CONFDIR}/${I}.orig **********";\
            ${ECHO} "";\
            diff ${CONFDIR}/${I} ${CONFDIR}/${I}.orig || true;\
            ${ECHO} "";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "*****************************************************************************";\
            ${ECHO} "";\
        fi
. endfor
.endif

subdirinstall:
.for I in ${SUBDIR}
	@(cd ${I};\
          ${MAKE} ${MAKEFLAGS} PKG="${PKG}" VMAJOR="${VMAJOR}" VERS="${VERS}" DATE="${DATE}"\
                  CFLAGSPLUS="${CFLAGSPLUS}" PREFIX="${PREFIX}"\
                  LIBEDIR="${LIBEDIR}" ROOTDATA="${ROOTDATA}"\
                  BINMODE="${BINMODE}" MANMODE="${MANMODE}" DATAMODE="${DATAMODE}"\
                  INSTALL_PROGRAM="${INSTALL_PROGRAM}"\
                  INSTALL_SCRIPT="${INSTALL_SCRIPT}"\
                  INSTALL_DATA="${INSTALL_DATA}"\
                  INSTALL_MAN="${INSTALL_MAN}"\
                  OWNER="${OWNER}" CHOWNER="${CHOWNER}"\
                  BINDIR="${BINDIR}" MAN1DIR="${MAN1DIR}" MAN8DIR="${MAN8DIR}"\
                  install\
        )
.endfor

#######################################################################################################
tarball:
	${MKDIR} -p ${DISTNM}
	${CP} -p ${SRCS} ${MANS1} ${MANS8} ${MISC} ${SQLS} ${CONF} ${DISTNM}/
.for I in ${SUBDIR}
	@(cd ${I}; ${MAKE} PKG="${PKG}" ${MAKEFLAGS} DISTNM="../${DISTNM}/${I}" tarball)
.endfor
.if defined(VMINOR)
	${TAR} -czvf ${DISTNM}.tar.gz ${DISTNM}
	${RM} -rf ${DISTNM}
.endif

#######################################################################################################
release: tarball prerelease dorelease postrelease

dorelease:
.if defined(VMINOR)
	${CVS} tag r${VMAJOR}_${VMINOR}
.endif
.for I in ${REMOTE_SRCDIR}
	${SCP} ${DISTNM}.tar.gz ${I}
.endfor
.for I in ${LOCAL_SRCDIR}
	${CP} ${DISTNM}.tar.gz ${I}
.endfor
	${MD5} ${DISTNM}.tar.gz
	${ECHO} "SIZE (${DISTNM}.tar.gz) = "`wc -c < "${DISTNM}.tar.gz"`

rerelease: delrelease release

delrelease:
.if defined(VMINOR)
	${CVS} tag -d r${VMAJOR}_${VMINOR}
.endif

#######################################################################################################
notify:
.if defined(REQUIRED)
	${BINDIR}/babololib-version ${REQUIRED}
.endif
	@${ECHO} "===> make in ${PKG}:${PWD}"

unnotify:
	@${ECHO} "===> end in ${PKG}:${PWD}"

preall:

postall:

preclean:

postclean:

preinstall:

postinstall:

prerelease:

postrelease:

clean: notify preclean doclean postclean

install: notify all preinstall subdirinstall doinstall postinstall unnotify
.if defined(VMINOR)
. if defined(PROTOVER)
	${ECHO} "${VMAJOR}.${VMINOR}" > "${LIBINCLUDEDIR}/${PKG}:${PROTOVER}.VERSION"
. else
	${ECHO} "${VMAJOR}.${VMINOR}" > "${LIBINCLUDEDIR}/${PKG}.VERSION"
. endif
.endif

all: notify preall Makefile ${SHLIBNAME} ${STLIBNAME} ${PROG} ${MGEN} ${SCRIPTS} ${MANZ1} ${MAN3ZRG} ${MANZ3} ${MANZ5} ${MANZ8} subdir ${DATA} postall unnotify

