/*-
 * Copyright (C)2003 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: BLINflag.h,v 1.5 2004/11/20 17:23:27 babolo Exp $
 */

typedef u_int32_t BLIN_flag;

#define BLIN_VER1    0x01000000
#define BLIN_VER2    0x02000000
#define BLIN_VER3    0x04000000
#define BLIN_VER4    0x08000000
#define BLIN_VER5    0x10000000
#define BLIN_VER6    0x20000000
#define BLIN_VER7    0x40000000
#define BLIN_VER8    0x80000000
#define BLIN_VERMASK 0xFF000000

#define ifBLIN_QV1(flag) if ((flag) & BLIN_VER1)
#define ifBLIN_QV2(flag) if ((flag) & BLIN_VER2)
#define ifBLIN_QV3(flag) if ((flag) & BLIN_VER3)
#define ifBLIN_QV4(flag) if ((flag) & BLIN_VER4)
#define ifBLIN_QV5(flag) if ((flag) & BLIN_VER5)
#define ifBLIN_QV6(flag) if ((flag) & BLIN_VER6)
#define ifBLIN_QV7(flag) if ((flag) & BLIN_VER7)
#define ifBLIN_QV8(flag) if ((flag) & BLIN_VER8)

#define BLIN_VERBOSE(flag) {(flag) |= ((((flag) << 1) & BLIN_VERMASK) | BLIN_VER1);}
#define kukBLIN_VERMASK(x) (((u_int32_t)(x) << 24) & BLIN_VERMASK)
#define setBLIN_VERMASK(flag,x) {(flag) &= ~BLIN_VERMASK; (flag) |= kukBLIN_VERMASK(x);}
#define getBLIN_VERMASK(flag) (((flag) >> 24) & (BLIN_VERMASK >> 24))

# ifdef ALLIGN_TABLE

#define BLIN_STATEHEADER(f, n) \
{   int BLIN_STATEVAR_i;                                                                              \
    fprintf((f), "control-");                                                                         \
    for (BLIN_STATEVAR_i = 0; BLIN_STATEVAR_i < 24; BLIN_STATEVAR_i++)                                \
        if  ((n)[BLIN_STATEVAR_i][0] != '-') fprintf((f), "-%s", (n)[BLIN_STATEVAR_i]);               \
    fprintf((f), "nst vl cl st     p    --- q ---\n");                                                \
}

#define BLIN_STATEBODY(f, n, r, cn, in, q, p, c, sn, s, C, e) \
{   int BLIN_STATEVAR_i, BLIN_STATEVAR_j, BLIN_STATEVAR_k;                                            \
    fprintf((f), "%08X ", (c));                                                                       \
    for ( BLIN_STATEVAR_i = 0, BLIN_STATEVAR_j = (c), BLIN_STATEVAR_k = 0                             \
        ; BLIN_STATEVAR_i < 24                                                                        \
        ; BLIN_STATEVAR_i++, BLIN_STATEVAR_j <<= 1                                                    \
        )                                                                                             \
        if  (((n)[BLIN_STATEVAR_i][0] != '-') || (BLIN_STATEVAR_j & 0x80000000))                      \
            fprintf( (f), "%s "                                                                       \
                   , (BLIN_STATEVAR_j & 0x80000000) ? (n)[BLIN_STATEVAR_i] : (u_char*)"  "            \
                   );                                                                                 \
    fprintf((f), "%s %02X %s %s %08X %08X\t~", (sn)[(c) & (C)], (r), (cn), (sn)[(s)], (p), (q));      \
    for ( BLIN_STATEVAR_i = 0; (in)[(q) + BLIN_STATEVAR_i] && (e); BLIN_STATEVAR_i++)                 \
        fprintf((f), "%c", (in)[(q) + BLIN_STATEVAR_i]);                                              \
    fprintf((f), "~\n");                                                                              \
}

# else

#define BLIN_STATEHEADER(f, n) \
{   fprintf((f), "-------- control ------nst rs cl st     p    --- q ---\n");}

#define BLIN_STATEBODY(f, n, r, cn, in, q, p, c, sn, s, C, e) \
{   int BLIN_STATEVAR_i, BLIN_STATEVAR_j, BLIN_STATEVAR_k;                                            \
    fprintf((f), "%08X ", (c));                                                                       \
    for ( BLIN_STATEVAR_i = 0, BLIN_STATEVAR_j = (c), BLIN_STATEVAR_k = 0                             \
        ; BLIN_STATEVAR_i < 24                                                                        \
        ; BLIN_STATEVAR_i++, BLIN_STATEVAR_j <<= 1                                                    \
        )                                                                                             \
        if  (BLIN_STATEVAR_j & 0x80000000) {                                                          \
            fprintf((f), "%s ", (n)[BLIN_STATEVAR_i]);                                                \
            BLIN_STATEVAR_k++;                                                                        \
        };                                                                                            \
    for (; BLIN_STATEVAR_k < 5; BLIN_STATEVAR_k++) fprintf((f), "   ");                               \
    fprintf((f), "%s %02X %s %s %08X %08X\t~", (sn)[(c) & (C)], (r), (cn), (sn)[(s)], (p), (q));    \
    for (BLIN_STATEVAR_i = 0; (in)[(q) + BLIN_STATEVAR_i] && (e); BLIN_STATEVAR_i++)                  \
        fprintf((f), "%c", (in)[(q) + BLIN_STATEVAR_i]);                                              \
    fprintf((f), "~\n");                                                                              \
}

# endif
