/*-
 * Copyright (C)2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: gene.c,v 1.2 2024/02/03 18:37:19 babolo Exp $"

#define BLIN_COMPAT      4

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <babolo/BLINflag.h>

int
main(int argc, char **argv) {
    u_int64_t p = 1;
    int64_t   f ;
    int       s = 1;

    blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FSET, BLIN_GEN0);
    if  (2 > argc) {
        printf("gene StartNum\n");
    } else {
        f = strtol(argv[1], NULL, 0);
        if  (0 > f) {
            f = -f;
            s = -1;
        }
        for (u_int64_t i = (u_int64_t)f; !!i; i += s) {
            if  (0xFFFF000000000000UL & ((p >> 16) * i)) break;
            p *= i;
            printf("%2lu %016lX %20lu\n", i, p, p);
}   }   }
