/*-
 * Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: aaacipatest.c,v 1.27 2024/05/26 18:45:15 babolo Exp $"

#define BLIN_COMPAT      4
#define MIFE_COMPAT      5

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <stddef.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <netdb.h>
#include <err.h>
#include <openssl/des.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "../aaacipa.h"

#define AAACIPA_MAXQSZ 255

int
main(int argc, char *argv[]) {
    struct {
        int64_t   cred        ;
        union {
            u_int64_t sess    ;
            struct {
                int32_t ex    ;
                int32_t errnom;
        };  };
        u_int32_t pflags      ;
        u_int32_t sflags      ;
        char      hash        [AAACIPA_HLEN + 1];
        int32_t   mzone       ;
        double    ttl         ;
        char      nick        [AAACIPA_NICKLEN + 1];
    }                result;
    querytabs_t      qtabs ;
    char             query [AAACIPA_MAXQSZ + 1];
    char             hash  [AAACIPA_HLEN + 1];
    struct addrinfo *hint  ;
    struct addrinfo *ai    ;
    int              ex    = EX_OK;
    aaacipa_cf      *cf    ;
    const char      *q     ;
    char            *g     ;
    u_int64_t        u     = 0;
    int              s     = 0;
    ssize_t          p     ;
    ssize_t          d     ;

    if  (!(cf = calloc(1, sizeof(aaacipa_cf)))) {
        ifBLIN_QW0("No mem %"BLIN_X, sizeof(aaacipa_cf));
        ex = EX_OSERR;
        goto out;
    }
    blin_ctl(BLIN_CTL_FLAG | BLIN_CTL_FSET, (cf->flags = BLIN_GEN0));
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    bzero(hash, AAACIPA_HLEN + 1);
    cf->cport = "1357";
    cf->key = 56;
    cf->iv = 78;
    if  (!!(ex = aaacipa_prep(cf))) {
        ifBLIN_QW0("aaacipa_prep");
        goto out;
    }
    if  (!(hint = calloc(1, sizeof(*hint)))) {
        ifBLIN_QW0("hint");
        ex = EX_OSERR;
        goto out;
    }
    if  (2 <= argc) s = argv[1][0];
    switch(s) {
    case 'I':
        cf->host = "127.0.0.1";
        hint->ai_family = PF_INET;
        hint->ai_protocol = IPPROTO_TCP;
        ifBLIN_QX0("inet %s:%s", cf->host, "1357");
        break;
    case 'L':
        cf->host = "/tmp/.s.aaacipa";
        hint->ai_family = PF_LOCAL;
        hint->ai_protocol = PF_UNSPEC;
        ifBLIN_QX0("local %s", cf->host);
        break;
    case 'D':
        u = 0xFFFFFFFFFFFFFFFF;
        s = -1;
        break;
    case 'U':
        u = 0x0000000000000000;
        s = 1;
        break;
    case 0:
        printf("aaacipatest I - 127.0.0.1:1357\n"
               "aaacipatest L - /tmp/.s.aaacipa\n"
               "aaacipatest D - 0xFFFFFFFFFFFFFFFF down\n"
               "aaacipatest U - 0x0000000000000000 up\n"
               );
        exit(ex);
    }
    if  (!cf->host) {
        u_int64_t b    ;

        if  (!s) {
            ifBLIN_QX0("No job");
            ex = EX_USAGE;
            errno = EPROCUNAVAIL;
            goto out;
        }
        for (; ; u += s) { /* unterminated */
            if  (!!(ex = aaacipa_endes(cf, u, hash))) {
                ifBLIN_QW0("aaacipa_endes");
                goto out;
            }
            if  (!!(ex = aaacipa_dedes(cf, &b, hash))) {
                ifBLIN_QW0("aaacipa_dedes");
                goto out;
            }
            if  (!(0x0FFFF & u)) ifBLIN_QX0("%016lX %s", u, hash);
            if  (u != b) {
                ifBLIN_QX0("%016lX %s %016lX", u, hash, b);
                ex = EX_SOFTWARE;
                errno = EDOOFUS;
                goto out;
    }   }   }
    hint->ai_socktype = SOCK_STREAM;
    hint->ai_flags = AI_NUMERICSERV | AI_ADDRCONFIG;
    if  ((ex = getaddrinfo(cf->host, cf->cport, hint, &ai))) {
        ifBLIN_QX0("getaddrinfo %s", gai_strerror(ex));
        ex = EX_OSERR;
        errno = EPROTO;
        goto out;
    }
    if  (0 > (s = socket(ai->ai_family, ai->ai_socktype, ai->ai_protocol))) {
        ifBLIN_QW0("socket");
        ex = EX_OSERR;
        goto out;
    }
    if  (0 > connect(s, ai->ai_addr, ai->ai_addrlen)) {
        ifBLIN_QW0("connect");
        ex = EX_OSERR;
        goto out;
    }
    freeaddrinfo(ai);
    bzero(query, AAACIPA_MAXQSZ + 1);
    p = 0;
    switch(atoi(&argv[1][1])) {
    case qryaaa:
        query[p++] = qryaaa; /* query type */
        /* context */
        q = "test";
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        /* srcip */
        q = "127.0.0.1";
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        /* user */
        q = "b";
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        /* password */
        q = "b";
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        /* cheme */
        q = "http";
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        /* request */
        g = NULL;
        if  (2 < argc) {
            asprintf(&g, "GET /?%s=5632 HTTP/1.1", argv[2]);
            q = g;
        } else {
            q = "GET /?3256VvfXHdb=5632 HTTP/1.1";
        }
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        free(g);
        if  (p >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        blin_dumb(0, query, p + 1);
        ifBLIN_QX0("write %zd->%zd", p, (d = write(s, query, (size_t)p)));
        if  (0 > d) {
            ifBLIN_QW0("write");
            ex = EX_IOERR;
            goto out;
        }
        if  (0 > (d = read(s, &result, AAACIPA_MAXCRED + AAACIPA_NICKLEN))) {
            ifBLIN_QW0("read");
            ex = EX_IOERR;
            goto out;
        }
        if  (0 > close(s)) {
            ifBLIN_QW0("close");
            ex = EX_IOERR;
            goto out;
        }
        blin_dumb(0, &result, AAACIPA_MAXCRED + AAACIPA_NICKLEN);
        if  (0 >= d) {
            ifBLIN_QX0("NO read %zd", d);
        } else if (8 >= d) {
            ifBLIN_QX0("read %zd CREDENTIALS=%ld", d, result.cred);
        } else if (16 >= d) {
            ifBLIN_QX0("read %zd CREDENTIALS=%ld SESSION=%lu", d, result.cred, result.sess);
        } else if (20 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      );
        } else if (24 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      );
        } else if (36 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X HASH=%.*s"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      , 11, result.hash
                      );
        } else if (40 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X HASH=%.*s TZ=%d"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      , 11, result.hash
                      , result.mzone
                      );
        } else if (48 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X HASH=%.*s TZ=%d TTL=%f"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      , 11, result.hash
                      , result.mzone
                      , result.ttl
                      );
        } else {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X "
                        "HASH=%.*s TZ=%d TTL=%f NICK=%s~"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      , 11, result.hash
                      , result.mzone
                      , result.ttl
                      , result.nick
                      );
        }
        if  (0 > (s = socket(ai->ai_family, ai->ai_socktype, ai->ai_protocol))) {
            ifBLIN_QW0("socket");
            ex = EX_OSERR;
            goto out;
        }
        if  (0 > connect(s, ai->ai_addr, ai->ai_addrlen)) {
            ifBLIN_QW0("connect");
            ex = EX_OSERR;
            goto out;
        }
        query[17] = '=';
        blin_dumb(0, query, p + 1);
        ifBLIN_QX0("write %zd->%zd", p, (d = write(s, query, (size_t)p)));
        if  (0 > d) {
            ifBLIN_QW0("write");
            ex = EX_IOERR;
            goto out;
        }
        if  (0 > (d = read(s, &result, AAACIPA_MAXCRED + AAACIPA_NICKLEN))) {
            ifBLIN_QW0("read");
            ex = EX_IOERR;
            goto out;
        }
        if  (0 > close(s)) {
            ifBLIN_QW0("close");
            ex = EX_IOERR;
            goto out;
        }
        blin_dumb(0, &result, AAACIPA_MAXCRED + AAACIPA_NICKLEN);
        if  (0 >= d) {
            ifBLIN_QX0("NO read %zd", d);
        } else if (8 >= d) {
            ifBLIN_QX0("read %zd CREDENTIALS=%ld", d, result.cred);
        } else if (16 >= d) {
            ifBLIN_QX0("read %zd CREDENTIALS=%ld SESSION=%lu"
                      , d
                      , result.cred
                      , result.sess
                      );
        } else if (20 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      );
        } else if (24 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      );
        } else if (36 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X HASH=%.*s"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      , 11, result.hash
                      );
        } else if (40 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X HASH=%.*s TZ=%d"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      , 11, result.hash
                      , result.mzone
                      );
        } else if (48 >= d) {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X HASH=%.*s TZ=%d TTL=%f"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      , 11, result.hash
                      , result.mzone
                      , result.ttl
                      );
        } else {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld SESSION=%lu F=%08X f=%08X "
                        "HASH=%.*s TZ=%d TTL=%f NICK=%s~"
                      , d
                      , result.cred
                      , result.sess
                      , result.pflags
                      , result.sflags
                      , 11, result.hash
                      , result.mzone
                      , result.ttl
                      , result.nick
                      );
        }
        break;
    case qrycre:
        query[p++] = qrycre; /* query type */
        p += 3;
        query[p++] = (char)192;
        p += 3;
        /* context */
        q = "test";
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        /* user */
        q = argv[2];
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        /* password */
        q = argv[3];
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        /* nick */
        q = argv[4];
        query[p] = (char)strlen(q) + 1; /* q is short enough */
        if  ((p + query[p]) >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        ++p;
        d = (ssize_t)strlcpy(&query[p], q, (size_t)(AAACIPA_MAXQSZ - p));
        p += d;
        if  (p >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        blin_dumb(0, query, p + 1);
        ifBLIN_QX0("write %zd->%zd", p, (d = write(s, query, (size_t)p)));
        if  (0 > d) {
            ifBLIN_QW0("write");
            ex = EX_IOERR;
            goto out;
        }
        if  (0 > (d = read(s, &result, AAACIPA_CRELEN))) {
            ifBLIN_QW0("read");
            ex = EX_IOERR;
            goto out;
        }
        if  (0 > close(s)) {
            ifBLIN_QW0("close");
            ex = EX_IOERR;
            goto out;
        }
        blin_dumb(0, &result, AAACIPA_CRELEN);
        if  (0 >= d) {
            ifBLIN_QX0("NO read %zd", d);
        } else if (AAACIPA_CRELEN > d) {
            ifBLIN_QX0("read %zd CREDENTIALS=%ld", d, result.cred);
        } else {
            ifBLIN_QX0( "read %zd CREDENTIALS=%ld ex=%d errno=%d"
                      , d
                      , result.cred
                      , result.ex
                      , result.errnom
                      );
        }
        break;
    case qrydel:
        /* FALLTHROUGH */
    case qrypas:
        /* FALLTHROUGH */
    case qrypasc:
        /* FALLTHROUGH */
    case qryses:
        /* FALLTHROUGH */
    case qrysesc:
        /* FALLTHROUGH */
    case qryseb:
        /* FALLTHROUGH */
    case qrysebc:
        /* FALLTHROUGH */
    case qryflo:
        /* FALLTHROUGH */
    case qryfla:
        /* FALLTHROUGH */
    case qryslo:
        qtabs.type[0] = argv[1][1] & 0x0F; /* query type */
        qtabs.cred = 1;
        qtabs.sess = 257;
        if  (qrydel == (argv[1][1] & 0x0F)) qtabs.sess = 202;
        q = "test";
        p = (ssize_t)strlen(q) + 1;
        qtabs.context[0] = (char)p; /* q is short enough */
        if  (p >= AAACIPA_MAXQSZ) {
            ifBLIN_QX0("too long query");
            ex = EX_USAGE;
            errno = E2BIG;
            goto out;
        }
        p = offsetof(querytabs_t, context);
        d = (ssize_t)strlcpy(&qtabs.context[1], q, AAACIPA_MAXQSZ);
        p += d;
        blin_dumb(0, &qtabs, p + 1);
        ifBLIN_QX0("write %zd->%zd", p, (d = write(s, &qtabs, (size_t)p + 1)));
        if  (0 > d) {
            ifBLIN_QW0("write");
            ex = EX_IOERR;
            goto out;
        }
        do {
            char    buf[65536];
            ssize_t b  ;

            if  (0 > (d = read(s, buf, 65536))) {
                ifBLIN_QW0("read");
                ex = EX_IOERR;
                goto out;
            }
            if  (!d) break;
            if  (0 > (b = write(fileno(stdout), buf, (size_t)d))) {
                ifBLIN_QW0("write");
                ex = EX_IOERR;
                goto out;
            } else if (b != d) {
                ifBLIN_QX0("read %zd <> write %zd", b, d);
                ex = EX_IOERR;
                goto out;
            }
        } while(d > 0);
        if  (0 > (s = socket(ai->ai_family, ai->ai_socktype, ai->ai_protocol))) {
            ifBLIN_QW0("socket");
            ex = EX_OSERR;
            goto out;
        }
        if  (0 > connect(s, ai->ai_addr, ai->ai_addrlen)) {
            ifBLIN_QW0("connect");
            ex = EX_OSERR;
            goto out;
        }
        qtabs.cred = 0;
        blin_dumb(0, &qtabs, p + 1);
        ifBLIN_QX0("write %zd->%zd", p, (d = write(s, &qtabs, (size_t)p + 1)));
        if  (0 > d) {
            ifBLIN_QW0("write");
            ex = EX_IOERR;
            goto out;
        }
        do {
            char    buf[65536];
            ssize_t b  ;

            if  (0 > (d = read(s, buf, 65536))) {
                ifBLIN_QW0("read");
                ex = EX_IOERR;
                goto out;
            }
            if  (!d) break;
            if  (0 > (b = write(fileno(stdout), buf, (size_t)d))) {
                ifBLIN_QW0("write");
                ex = EX_IOERR;
                goto out;
            } else if (b != d) {
                ifBLIN_QX0("read %zd <> write %zd", b, d);
                ex = EX_IOERR;
                goto out;
            }
        } while(d > 0);
        if  (0 > close(s)) {
            ifBLIN_QW0("close in");
            ex = EX_IOERR;
            goto out;
        }
        if  (0 > close(fileno(stdout))) {
            ifBLIN_QW0("close stdout");
            ex = EX_IOERR;
            goto out;
    }   }
out:
    exit(ex);
}
