/*-
 * Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: sql.c,v 1.29 2024/05/26 18:45:15 babolo Exp $"

#define BLIN_COMPAT      4
#define MIFE_COMPAT      5
#define AAACIPA_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#if defined(USEBDB)
# include <dbsql.h>
#elif defined(USESQLITE3)
# include <sqlite3.h>
#elif defined(USESQLITE2)
# include <sqlite.h>
#endif
#include <openssl/des.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "aaacipa.h"

const static char qook[] =
    "PRAGMA multiversion = on;\n"
    "PRAGMA snapshot_isolation = on;\n"
    "PRAGMA auto_vacuum = INCREMENTAL;\n"
    "PRAGMA foreign_keys = 1;\n"
    "PRAGMA temp_store = 2;\n";

const static char qaaa[] =
    "SELECT \"%s\".\"%s\"\n"
    " FROM \"%s\"\n"
    " WHERE \"%s\".\"%s\" == ?\n"
    "   AND \"%s\".\"%s\" == ?\n"
    "   AND (\"%s\".\"%s\" == ? OR \"%s\".\"%s\" IS NULL)\n"
    "   AND (\"%s\".\"%s\" == ? OR \"%s\".\"%s\" IS NULL)\n"
    "ORDER BY \"%s\".\"%s\" DESC\n"
    "LIMIT 1\n"
    ";";

const static char qarams[] =
    "SELECT \"%s\".\"%s1\"\n"
    "     , \"%s\".\"%s2\"\n"
    "     , \"%s\".\"%s3\"\n"
    "     , \"%s\".\"%s4\"\n"
    "     , \"%s\".\"%s5\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    " FROM \"%s\"\n"
    "LIMIT 1\n"
    ";";

const static char qttl[] =
    "SELECT COALESCE(\"%s\".\"%s\", \"%s\".\"%s\")\n"
    "     , COALESCE(\"%s\".\"%s\", \"%s\".\"%s\")\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    " FROM \"%s\" LEFT JOIN \"%s\"\n"
    "   ON(\"%s\".\"%s\" == ? AND \"%s\".\"%s\" == \"%s\".\"%s\")\n"
    " WHERE \"%s\".\"%s\" == ?\n"
    ";";

const static char qsup[] =
    "UPDATE \"%s\" SET \"%s\" = ?\n"
    "     , \"%s\" = \"%s\" + 1\n"
    " WHERE \"%s\".\"%s\" == ?\n"
    "   AND \"%s\".\"%s\" == ?\n"
    "   AND \"%s\".\"%s\" == ?\n"
    "   AND \"%s\" >= ?\n"
    "   AND (  \"%s\".\"%s\" > 0\n"
    "       OR NOT ?\n"
    "       OR (\"%s\".\"%s\" == ? AND \"%s\".\"%s\" IS ?)\n"
    "       )\n"
    ";";

const static char qins[] =
    "INSERT INTO \"%s\"(\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\")\n"
    " SELECT ?1, ?2, ?3, ?4, \"%s\".\"%s\" & 15, ?5\n"  /*** PassToSess ***/
    "  FROM \"%s\"\n"
    "  WHERE \"%s\" == ?1\n"
    ";";

const static char qhsh[] =
    "UPDATE \"%s\" SET \"%s\" = ?, \"%s\" = \"%s\"\n"
    " WHERE \"%s\" == ?\n"
    ";";

const static char qpas[] =
    "SELECT \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    " FROM \"%s\"\n"
    " WHERE COALESCE(\"%s\" == ?2, 1)\n"
    "   AND (0 <> \"%s\" OR ?2 IS NULL)\n"
    "   AND \"%s\" == ?1\n"
    "ORDER BY \"%s\"\n"
    ";\n";

const static char qses[] =
    "SELECT \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    " FROM \"%s\" JOIN \"%s\" USING(\"%s\")\n"
    " WHERE \"%s\" == ?1\n"
    "   AND CASE WHEN ?2 IS NULL THEN 1\n"
    "            WHEN ?2 == 0 THEN \"%s\" == ?3\n"
    "            ELSE \"%s\" == ?2\n"
    "       END\n"
    "ORDER BY \"%s\", \"%s\"\n"
    ";\n";

const static char qseb[] =
    "SELECT \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    "     , \"%s\".\"%s\"\n"
    " FROM \"%s\" JOIN \"%s\" USING(\"%s\")\n"
    " WHERE \"%s\" == ?1\n"
    "   AND CASE WHEN ?2 IS NULL THEN 1\n"
    "            WHEN ?2 == 0 THEN 0\n"
    "            ELSE \"%s\" == ?2\n"
    "       END\n"
    "ORDER BY \"%s\", \"%s\"\n"
    ";\n";

const static char qdel[] =
    "UPDATE \"%s\" SET \"%s\" = 0\n"
    " WHERE \"%s\" == ?1\n"
    "   AND 0 <> \"%s\"\n"
    "   AND \"%s\" == ?2\n"
    "   AND (\"%s\" == ?3 OR 0 == ?3)\n"
    ";\n";

const static char qflo[] =
    "UPDATE \"%s\" SET \"%s\" = \"%s\" & ~16\n" /*** PassClaimPass ***/
    " WHERE \"%s\" & 16\n"                      /*** PassClaimPass ***/
    "   AND \"%s\" == ?1\n"
    "   AND 0 <> \"%s\"\n"
    "   AND \"%s\" == ?2 \n"
    ";\n";

const static char qfla[] =
    "UPDATE \"%s\" SET \"%s\" = \"%s\" | 16\n" /*** PassClaimPass ***/
    " WHERE NOT (\"%s\" & 16)\n"               /*** PassClaimPass ***/
    "   AND \"%s\" == ?1\n"
    "   AND 0 <> \"%s\"\n"
    "   AND \"%s\" == ?2 \n"
    ";\n";

const static char qslo[] =
    "UPDATE \"%s\" SET \"%s\" = \"%s\" & ~1\n" /*** SessClaimPass ***/
    " WHERE \"%s\" & 1\n"                      /*** SessClaimPass ***/
    "   AND \"%s\" == ?2\n"
    "   AND \"%s\" == ?3\n"
    ";\n";

const static char qcre[] =
    "INSERT INTO \"%s\"\n"
    "     ( \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     , \"%s\"\n"
    "     )\n"
    " VALUES(?, ?, ?, ?, ?)\n"
    ";\n";

static char *
quote(aaacipa_cf *cf, const char *o) {
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    char   *res = NULL;
    size_t  s   ;
    size_t  k   ;
    size_t  i   ;

    if  (!o) {
        res = strdup("\\N");
    } else {
        s = strlen(o);
        if  (!(res = malloc(s * 2 + 1))) {
            ifBLIN_QW0("No mem");
            goto out;
        }
        for (k = 0, i = 0; !!o[i]; ++i) {
            if  (k > (s * 2)) {
                ifBLIN_QX0("Out bums");
                errno = EDOOFUS;
                goto out;
            }
            switch(o[i]) {
            case 0x08: res[k++] = '\\'; res[k++] = 'b';   break;
            case 0x09: res[k++] = '\\'; res[k++] = 't';   break;
            case 0x0A: res[k++] = '\\'; res[k++] = 'n';   break;
            case 0x0B: res[k++] = '\\'; res[k++] = 'v';   break;
            case 0x0C: res[k++] = '\\'; res[k++] = 'f';   break;
            case 0x0D: res[k++] = '\\'; res[k++] = 'r';   break;
            case '\\': res[k++] = '\\'; res[k++] = '\\';  break;
            default: res[k++] = o[i];
        }   }
        res[k] = '\0';
    }
out:
    return(res);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_cook(aaacipa_cf *cf) {                                                                     /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    int           exx;
    aaacipa_dbh  *db     = NULL;
    int           ex     = EX_OK;
    char         *q      ;
    int           i      ;

    ifBLIN_QX2("+");
    if  (!cf->dbhandler && !(cf->dbhandler = calloc(1, sizeof(aaacipa_dbh)))) {
        ifBLIN_QW0("calloc dbhandler");
        ex = EX_OSERR;
        goto out;
    }
    db = (aaacipa_dbh *)cf->dbhandler;
    if  (!!(ex = sqlite3_initialize())) {
        ifBLIN_QX0("Could not initialize @%d: %s(%d)", __LINE__, aaacipa_exdeco(ex), ex);
        ex = EX_SOFTWARE;
        errno = ECANCELED;
        goto out;
    }
    ex = sqlite3_open_v2( cf->dbfile
                        , &db->odf
                        , SQLITE_OPEN_READWRITE | SQLITE_OPEN_SHAREDCACHE
                        , NULL
                        );
    if  (!!ex) {
        sqlite3_shutdown();
        ifBLIN_QX0("Could not open password DB @%d: %s(%d): %s"
                  , __LINE__
                  , aaacipa_exdeco(ex)
                  , ex
                  , cf->dbfile
                  );
        ex = EX_SOFTWARE;
        errno = ECANCELED;
        goto out;
    }
    if  (!!(ex = sqlite3_extended_result_codes(db->odf, 1))) {
        ifBLIN_QX1("Could not extend result codes: %s(%d)", aaacipa_exdeco(ex), ex);
    }
    if  (!!(ex = sqlite3_exec(db->odf, qook, NULL, NULL, &q))) {
        ifBLIN_QX0("PRAGMA: %s", q);
        sqlite3_free(q);
        q = NULL;
        ex = EX_SOFTWARE;
        errno = ECANCELED;
        goto out;
    }
    ex = asprintf( &q
                 , qarams
                 , cf->cipaconf
                 , cf->fieldreo
                 , cf->cipaconf
                 , cf->fieldreo
                 , cf->cipaconf
                 , cf->fieldreo
                 , cf->cipaconf
                 , cf->fieldreo
                 , cf->cipaconf
                 , cf->fieldreo
                 , cf->cipaconf
                 , cf->fieldkey
                 , cf->cipaconf
                 , cf->fieldvinit
                 , cf->cipaconf
                 , cf->fieldttl
                 , cf->cipaconf
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for conf query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qarams=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmprm, NULL))) {
        ex = aaacipa_ce(db, &db->vmprm, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    switch((ex = sqlite3_step(db->vmprm))) {
    case SQLITE_ROW:
        i = sqlite3_column_count(db->vmprm);
        if  (i != 8) {
            ifBLIN_QX0("Col num %d IN qarams", i);
            ex = aaacipa_ce(db, &db->vmprm, "", __LINE__, 0, "", 0);
            goto out;
        }
        for (int k = 0; k < 5; ++k) {
            if  (SQLITE_NULL == sqlite3_column_type(db->vmprm, k)) {
                ex = aaacipa_ce(db, &db->vmprm, "reord", __LINE__, 0, "NULL", k);
                goto out;
            }
            cf->vector[k] = (u_int64_t)sqlite3_column_int64(db->vmprm, k);
        }
        if  (SQLITE_NULL == sqlite3_column_type(db->vmprm, 5)) {
            ex = aaacipa_ce(db, &db->vmprm, "key", __LINE__, 0, "", 0);
            goto out;
        }
        cf->key = (u_int64_t)sqlite3_column_int64(db->vmprm, 5);
        if  (SQLITE_NULL == sqlite3_column_type(db->vmprm, 6)) {
            ex = aaacipa_ce(db, &db->vmprm, "hash init vector", __LINE__, 0, "", 0);
            goto out;
        }
        cf->iv = (u_int64_t)sqlite3_column_int64(db->vmprm, 6);
        if  (SQLITE_NULL == sqlite3_column_type(db->vmprm, 7)) {
            ex = aaacipa_ce(db, &db->vmprm, "TTL", __LINE__, 0, "", 0);
            goto out;
        }
        cf->ttl = sqlite3_column_double(db->vmprm, 7);
        break;
    case SQLITE_DONE:
        break;
    default:
        ex = aaacipa_ce(db, &db->vmprm, "step params", __LINE__, 0, "", 0);
        goto out;
    }
    free(q);
    q = NULL;
    if  (!db->vmprm || !!(ex = sqlite3_reset(db->vmprm))) {
        ifBLIN_QW0("Could not reset @%d: %s(%d)", __LINE__, aaacipa_exdeco(ex), ex);
    }
    if  (!db->vmprm || !!(ex = sqlite3_finalize(db->vmprm))) {
        ifBLIN_QW0("Could not finalize @%d: %s(%d)", __LINE__, aaacipa_exdeco(ex), ex);
    }
    db->vmprm = NULL;
    ex = asprintf( &q
                 , qaaa
                 , cf->passwd
                 , cf->fieldcred
                 , cf->passwd
                 , cf->passwd
                 , cf->fieldcontext
                 , cf->passwd
                 , cf->fieldlogin
                 , cf->passwd
                 , cf->fieldpass
                 , cf->passwd
                 , cf->fieldpass
                 , cf->passwd
                 , cf->fieldsrcip
                 , cf->passwd
                 , cf->fieldsrcip
                 , cf->passwd
                 , cf->fieldcred
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for AAA query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qaaa=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmaaa, NULL))) {
        ex = aaacipa_ce(db, &db->vmaaa, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    ex = asprintf( &q
                 , qttl
                 , cf->sessions
                 , cf->fieldttl
                 , cf->passwd
                 , cf->fieldttl
                 , cf->sessions
                 , cf->fieldmzone
                 , cf->passwd
                 , cf->fieldmzone
                 , cf->passwd
                 , cf->fieldnick
                 , cf->passwd
                 , cf->fieldpflags
                 , cf->sessions
                 , cf->fieldsflags
                 , cf->passwd
                 , cf->sessions
                 , cf->sessions
                 , cf->fieldsess
                 , cf->sessions
                 , cf->fieldcred
                 , cf->passwd
                 , cf->fieldcred
                 , cf->passwd
                 , cf->fieldcred
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for TTL query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qttl=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmttl, NULL))) {
        ex = aaacipa_ce(db, &db->vmttl, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qsup
                 , cf->sessions
                 , cf->fieldupdt
                 , cf->fieldcnt
                 , cf->fieldcnt
                 , cf->sessions
                 , cf->fieldsess
                 , cf->sessions
                 , cf->fieldcred
                 , cf->sessions
                 , cf->fieldsessip
                 , cf->fieldupdt
                 , cf->sessions
                 , cf->fieldcred
                 , cf->sessions
                 , cf->fieldlogin
                 , cf->sessions
                 , cf->fieldpass
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for session update query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qsup=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmsup, NULL))) {
        ex = aaacipa_ce(db, &db->vmsup, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qins
                 , cf->sessions
                 , cf->fieldcred
                 , cf->fieldlogin
                 , cf->fieldpass
                 , cf->fieldsessip
                 , cf->fieldflags
                 , cf->fieldcreat
                 , cf->passwd
                 , cf->fieldflags
                 , cf->passwd
                 , cf->fieldcred
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for session install query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qins=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmins, NULL))) {
        ex = aaacipa_ce(db, &db->vmins, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qhsh
                 , cf->sessions
                 , cf->fieldhash
                 , cf->fieldupdt
                 , cf->fieldcreat
                 , cf->fieldsess
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for session install query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qhsh=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmhsh, NULL))) {
        ex = aaacipa_ce(db, &db->vmhsh, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qpas
                 , cf->fieldcred
                 , cf->fieldcontext
                 , cf->fieldlogin
                 , cf->fieldpass
                 , cf->fieldsrcip
                 , cf->fieldpflags
                 , cf->fieldttl
                 , cf->fieldmzone
                 , cf->fieldnick
                 , cf->fieldremark
                 , cf->passwd
                 , cf->fieldcred
                 , cf->fieldcred
                 , cf->fieldcontext
                 , cf->fieldcred
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for pass table query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qpas=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmpas, NULL))) {
        ex = aaacipa_ce(db, &db->vmpas, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qses
                 , cf->sessions
                 , cf->fieldsess
                 , cf->sessions
                 , cf->fieldhash
                 , cf->sessions
                 , cf->fieldcred
                 , cf->sessions
                 , cf->fieldcnt
                 , cf->sessions
                 , cf->fieldsrcip
                 , cf->sessions
                 , cf->fieldsflags
                 , cf->sessions
                 , cf->fieldlogin
                 , cf->sessions
                 , cf->fieldpass
                 , cf->sessions
                 , cf->fieldttl
                 , cf->sessions
                 , cf->fieldmzone
                 , cf->sessions
                 , cf->fieldcre
                 , cf->sessions
                 , cf->fieldupd
                 , cf->sessions
                 , cf->passwd
                 , cf->fieldcred
                 , cf->fieldcontext
                 , cf->fieldsess
                 , cf->fieldcred
                 , cf->fieldcred
                 , cf->fieldsess
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for sess table query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qses=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmses, NULL))) {
        ex = aaacipa_ce(db, &db->vmses, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qseb
                 , cf->sessionb
                 , cf->fieldsess
                 , cf->sessionb
                 , cf->fieldcred
                 , cf->sessionb
                 , cf->fieldcnt
                 , cf->sessionb
                 , cf->fieldsrcip
                 , cf->sessionb
                 , cf->fieldsflags
                 , cf->sessionb
                 , cf->fieldlogin
                 , cf->sessionb
                 , cf->fieldpass
                 , cf->sessionb
                 , cf->fieldttl
                 , cf->sessionb
                 , cf->fieldmzone
                 , cf->sessionb
                 , cf->fieldcre
                 , cf->sessionb
                 , cf->fieldupd
                 , cf->sessionb
                 , cf->fielddel
                 , cf->sessionb
                 , cf->passwd
                 , cf->fieldcred
                 , cf->fieldcontext
                 , cf->fieldcred
                 , cf->fieldcred
                 , cf->fieldsess
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for sessb table query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qseb=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmseb, NULL))) {
        ex = aaacipa_ce(db, &db->vmseb, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qdel
                 , cf->sessions
                 , cf->fieldupd
                 , cf->fieldcontext
                 , cf->fieldcred
                 , cf->fieldcred
                 , cf->fieldsess
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for sessb table query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qdel=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmdel, NULL))) {
        ex = aaacipa_ce(db, &db->vmdel, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qflo
                 , cf->passwd
                 , cf->fieldpflags
                 , cf->fieldpflags
                 , cf->fieldpflags
                 , cf->fieldcontext
                 , cf->fieldcred
                 , cf->fieldcred
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for drop cred flag query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qflo=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmflo, NULL))) {
        ex = aaacipa_ce(db, &db->vmflo, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qfla
                 , cf->passwd
                 , cf->fieldpflags
                 , cf->fieldpflags
                 , cf->fieldpflags
                 , cf->fieldcontext
                 , cf->fieldcred
                 , cf->fieldcred
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for set cred flag query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qfla=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmfla, NULL))) {
        ex = aaacipa_ce(db, &db->vmfla, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qslo
                 , cf->sessions
                 , cf->fieldsflags
                 , cf->fieldsflags
                 , cf->fieldsflags
                 , cf->fieldcred
                 , cf->fieldsess
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for drop sess flag query string");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qslo=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmslo, NULL))) {
        ex = aaacipa_ce(db, &db->vmslo, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
    ex = asprintf( &q
                 , qcre
                 , cf->passwd
                 , cf->fieldcontext
                 , cf->fieldlogin
                 , cf->fieldpass
                 , cf->fieldpflags
                 , cf->fieldnick
                 );
    if  (0 > ex) {
        ifBLIN_QW0("no mem for create user");
        ex = EX_OSERR;
        goto out;
    }
    ifBLIN_QX3("qcre=%s~", q);
    if  (!!(ex = sqlite3_prepare_v2(db->odf, q, -1, &db->vmcre, NULL))) {
        ex = aaacipa_ce(db, &db->vmcre, q, __LINE__, ex, cf->dbfile, 0);
        goto out;
    }
    free(q);
    q = NULL;
out:
    exx = ex;
    if  (!!db->vmprm || !!(ex = sqlite3_finalize(db->vmprm))) {
        ifBLIN_QW0("Could not finalize @%d: %s(%d)", __LINE__, aaacipa_exdeco(ex), ex);
    }
    db->vmprm = NULL;
    if  (!!exx) ex = exx;
    if  (!!ex) {
        aaacipa_fini(db, NULL);
        if  (!!cf->dbhandler) {
            free(cf->dbhandler);
            cf->dbhandler = NULL;
        }
        ex = exx;
    }
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_reset(aaacipa_cf *cf, int ln, sqlite3_stmt  *vm) {                                         /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    int ex = EX_OK;

    ifBLIN_QX2("+ %d", ln);
    if  (!!vm && !!(ex = sqlite3_clear_bindings(vm))) {
        ifBLIN_QX0("Could not clear @%d: %s(%d)", ln, aaacipa_exdeco(ex), ex);
        errno = EDOOFUS;
        ex = EX_SOFTWARE;
        goto out;
    }
    if  (!!vm && !!(ex = sqlite3_reset(vm))) {
        ifBLIN_QX0("Could not reset @%d: %s(%d)", ln, aaacipa_exdeco(ex), ex);
        errno = EPROCUNAVAIL;
        ex = EX_SOFTWARE;
        goto out;
    }
out:
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_getaaa(aaacipa_cf *cf, aaacipa_pass *pass) {                                               /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    aaacipa_dbh   *db       = (aaacipa_dbh *)cf->dbhandler;
    sqlite3_stmt  *vm       = db->vmaaa;
    sqlite3_stmt **vvm      = &db->vmaaa;
    int            ex       = EX_OK;
    int            i        ;

    ifBLIN_QX2("+");
    i = 0;
    ifBLIN_QX3("bind vmaaa %d=%s~", i, pass->context);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->context, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->context, __LINE__, ex, "Could not bind context", i);
        goto out;
    }
    ifBLIN_QX3("bind vmaaa %d=%s~", i, pass->user);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->user, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->user, __LINE__, ex, "Could not bind user", i);
        goto out;
    }
    ifBLIN_QX3("bind vmaaa %d=%s~", i, pass->password);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->password, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->password, __LINE__, ex, "Could not bind password", i);
        goto out;
    }
    ifBLIN_QX3("bind vmaaa %d=%s~", i, pass->srcip);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->srcip, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->srcip, __LINE__, ex, "Could not bind srcip", i);
        goto out;
    }
    ex = sqlite3_step(vm);
    ifBLIN_QX3("step %d", ex);
    switch(ex) {
    case SQLITE_ROW:
        i = sqlite3_column_count(vm);
        ifBLIN_QX3("row %d", i);
        if  (i != 1) {
            ifBLIN_QX0("Col num %d IN qaaa", i);
            ex = aaacipa_ce(db, vvm, "", __LINE__, 0, "", 0);
            goto out;
        }
        if  (SQLITE_NULL != sqlite3_column_type(vm, 0)) {
            pass->cred = sqlite3_column_int64(vm, 0);
        }
        ex = EX_OK;
        break;
    case SQLITE_DONE:
        ifBLIN_QX3("done");
        ex = EX_OK;
        break;
    default:
        ex = aaacipa_ce(db, vvm, "step AAA", __LINE__, 0, "", 0);
        goto out;
    }
    if  (!!(ex = aaacipa_reset(cf, __LINE__, vm))) {
        ifBLIN_QW0("aaacipa_reset");
        goto out;
    }
out:
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_getttl(aaacipa_cf *cf, aaacipa_pass *pass) {                                               /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    aaacipa_dbh   *db       = (aaacipa_dbh *)cf->dbhandler;
    sqlite3_stmt  *vm       = db->vmttl;
    sqlite3_stmt **vvm      = &db->vmttl;
    int            ex       = EX_OK;
    int            i        ;

    ifBLIN_QX2("+");
    i = 0;
    ifBLIN_QX3("bind vmttl %d=%lu", i, pass->sess);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->sess))) {
        ex = aaacipa_ce(db, vvm, "sess", __LINE__, ex, "Could not bind session", i);
        goto out;
    }
    ifBLIN_QX3("bind vmttl %d=%ld", i, pass->cred);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, pass->cred))) {
        ex = aaacipa_ce(db, vvm, "cred", __LINE__, ex, "Could not bind cred", i);
        goto out;
    }
    switch((ex = sqlite3_step(vm))) {
    case SQLITE_ROW:
        i = sqlite3_column_count(vm);
        if  (i != 5) {
            ifBLIN_QX0("Col num %d IN qttl", i);
            ex = aaacipa_ce(db, vvm, "", __LINE__, 0, "", 0);
            goto out;
        }
        if  (SQLITE_NULL != sqlite3_column_type(vm, 0)) {
            pass->ttl = sqlite3_column_double(vm, 0);
        } else {
            pass->ttl = cf->ttl;
        }
        pass->back = pass->now - pass->ttl;
        if  (SQLITE_NULL != sqlite3_column_type(vm, 1)) {
            pass->mzone = sqlite3_column_int(vm, 1);
        } else {
            pass->mzone = 0;
        }
        if  (SQLITE_NULL != sqlite3_column_type(vm, 2)) {
            strlcpy(pass->nick, (const char *)sqlite3_column_text(vm, 2), AAACIPA_NICKLEN + 1);
        } else {
            pass->nick[0] = '\0';
        }
        if  (SQLITE_NULL != sqlite3_column_type(vm, 3)) {
            pass->pflags = (u_int32_t)sqlite3_column_int(vm, 3);
        } else {
            pass->pflags = 0;
        }
        if  (SQLITE_NULL != sqlite3_column_type(vm, 4)) {
            pass->sflags = (u_int32_t)sqlite3_column_int(vm, 4);
        } else {
            pass->sflags = 0;
        }
        ifBLIN_QX3( "TTL=%f(%f) TZ=%d F=%08X f=%08X NICK=%s~"
                  , pass->ttl
                  , cf->ttl
                  , pass->mzone
                  , pass->pflags
                  , pass->sflags
                  , pass->nick
                  );
        ex = EX_OK;
        break;
    case SQLITE_DONE:
        ex = EX_OK;
        break;
    default:
        ex = aaacipa_ce(db, vvm, "", __LINE__, 0, "", 0);
        goto out;
    }
    if  (!!(ex = aaacipa_reset(cf, __LINE__, vm))) {
        ifBLIN_QW0("aaacipa_reset");
        goto out;
    }
out:
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_getsup(aaacipa_cf *cf, aaacipa_pass *pass) {                                               /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    aaacipa_dbh   *db       = (aaacipa_dbh *)cf->dbhandler;
    sqlite3_stmt  *vm       = db->vmsup;
    sqlite3_stmt **vvm      = &db->vmsup;
    int            ex       = EX_OK;
    int            i        ;

    ifBLIN_QX2("+");
    i = 0;
    ifBLIN_QX3("bind vmsup %d=%f", i, pass->now);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->now))) {
        ex = aaacipa_ce(db, vvm, "now", __LINE__, ex, "Could not bind now", i);
        goto out;
    }
    ifBLIN_QX3("bind vmsup %d=%lu", i, pass->sess);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->sess))) {
        ex = aaacipa_ce(db, vvm, "sess", __LINE__, ex, "Could not bind session", i);
        goto out;
    }
    ifBLIN_QX3("bind vmsup %d=%ld", i, pass->cred);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->cred))) {
        ex = aaacipa_ce(db, vvm, "cred", __LINE__, ex, "Could not bind cred", i);
        goto out;
    }
    ifBLIN_QX3("bind vmsup %d=%s~", i, pass->srcip);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->srcip, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->srcip, __LINE__, ex, "Could not bind srcip", i);
        goto out;
    }
    ifBLIN_QX3("bind vmsup %d=%f", i, pass->back);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->back))) {
        ex = aaacipa_ce(db, vvm, "back", __LINE__, ex, "Could not bind back", i);
        goto out;
    }
    ifBLIN_QX3("bind vmsup %d=%d", i, pass->crypt);
    if  (!!(ex = sqlite3_bind_int(vm, ++i, pass->crypt))) {
        ex = aaacipa_ce(db, vvm, "crypt", __LINE__, ex, "Could not bind crypt", i);
        goto out;
    }
    ifBLIN_QX3("bind vmsup %d=%s~", i, pass->user);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->user, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->user, __LINE__, ex, "Could not bind user", i);
        goto out;
    }
    ifBLIN_QX3("bind vmsup %d=%s~", i, pass->password);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->password, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->password, __LINE__, ex, "Could not bind pass", i);
        goto out;
    }
    switch((ex = sqlite3_step(vm))) {
    case SQLITE_ROW:
        ifBLIN_QX0("Why row IN qsup?");
        aaacipa_fini(db, NULL);
        ex = EX_SOFTWARE;
        errno = E2BIG;
        goto out;
    case SQLITE_DONE:
        switch(sqlite3_changes(db->odf)) {
        case 0:
            pass->sess = 0;
            break;
        case 1:
            break;
        default:
            ex = aaacipa_ce(db, vvm, "too many up", __LINE__, 0, "", 0);
            goto out;
        }
        ex = EX_OK;
        break;
    default:
        ex = aaacipa_ce(db, vvm, "step up", __LINE__, 0, "", 0);
        goto out;
    }
    if  (!!(ex = aaacipa_reset(cf, __LINE__, vm))) {
        ifBLIN_QW0("aaacipa_reset");
        goto out;
    }
out:
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_getins(aaacipa_cf *cf, aaacipa_pass *pass) {                                               /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    aaacipa_dbh   *db       = (aaacipa_dbh *)cf->dbhandler;
    sqlite3_stmt  *vm       = db->vmins;
    sqlite3_stmt **vvm      = &db->vmins;
    int            ex       = EX_OK;
    int            i        ;

    ifBLIN_QX2("+");
    i = 0;
    ifBLIN_QX3("bind vmins %d=%ld", i, pass->cred);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->cred))) {
        ex = aaacipa_ce(db, vvm, "cred", __LINE__, ex, "Could not bind cred", i);
        goto out;
    }
    ifBLIN_QX3("bind vmins %d=%s~", i, pass->user);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->user, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->user, __LINE__, ex, "Could not bind user", i);
        goto out;
    }
    ifBLIN_QX3("bind vmins %d=%s~", i, pass->password);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->password, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->password, __LINE__, ex, "Could not bind password", i);
        goto out;
    }
    ifBLIN_QX3("bind vmins %d=%s~", i, pass->srcip);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->srcip, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->srcip, __LINE__, ex, "Could not bind srcip", i);
        goto out;
    }
    ifBLIN_QX3("bind vmins %d=%f", i, pass->now);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->now))) {
        ex = aaacipa_ce(db, vvm, "now", __LINE__, ex, "Could not bind now", i);
        goto out;
    }
    switch((ex = sqlite3_step(vm))) {
    case SQLITE_ROW:
        ifBLIN_QX0("Why row IN qins?");
        aaacipa_fini(db, NULL);
        ex = EX_SOFTWARE;
        errno = E2BIG;
        goto out;
    case SQLITE_DONE:
        if  (!(pass->sess = (u_int64_t)sqlite3_last_insert_rowid(db->odf))) {
            ifBLIN_QX0("NO ins");
            aaacipa_fini(db, NULL);
            ex = EX_SOFTWARE;
            errno = EDOOFUS;
            goto out;
        }
        ex = EX_OK;
        break;
    default:
        ex = aaacipa_ce(db, vvm, "No ins", __LINE__, 0, "", 0);
        goto out;
    }
    if  (!!(ex = aaacipa_reset(cf, __LINE__, vm))) {
        ifBLIN_QW0("aaacipa_reset");
        goto out;
    }
out:
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_gethsh(aaacipa_cf *cf, aaacipa_pass *pass, const char *hash) {                             /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    aaacipa_dbh   *db       = (aaacipa_dbh *)cf->dbhandler;
    sqlite3_stmt  *vm       = db->vmhsh;
    sqlite3_stmt **vvm      = &db->vmhsh;
    int            ex       = EX_OK;
    int            i        ;

    ifBLIN_QX2("+");
    i = 0;
    ifBLIN_QX3("bind vmhsh %d=%s~", i, hash);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, hash, -1, SQLITE_TRANSIENT))) {
        ex = aaacipa_ce(db, vvm, hash, __LINE__, ex, "Could not bind hash", i);
        goto out;
    }
    ifBLIN_QX3("bind vmhsh %d=%lu", i, pass->sess);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->sess))) {
        ex = aaacipa_ce(db, vvm, "sess", __LINE__, ex, "Could not bind session", i);
        goto out;
    }
    switch((ex = sqlite3_step(vm))) {
    case SQLITE_ROW:
        ifBLIN_QX0("Why row IN qhsh?");
        aaacipa_fini(db, NULL);
        ex = EX_SOFTWARE;
        errno = E2BIG;
        goto out;
    case SQLITE_DONE:
        ex = EX_OK;
        break;
    default:
        ex = aaacipa_ce(db, vvm, "No ins", __LINE__, 0, "", 0);
        goto out;
    }
    if  (!!(ex = aaacipa_reset(cf, __LINE__, vm))) {
        ifBLIN_QW0("aaacipa_reset");
        goto out;
    }
out:
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_passq(aaacipa_cf *cf, aaacipa_pass *pass) {                                                /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    char          hash[AAACIPA_HLEN + 1];
    int           ex  = EX_OK;

    ifBLIN_QX2("+");
    if  (!!(ex = aaacipa_getaaa(cf, pass))) {
        ifBLIN_QW0("aaacipa_getaaa");
        goto out;
    }
    if  (!!(ex = aaacipa_getttl(cf, pass))) {
        ifBLIN_QW0("aaacipa_getttl");
        goto out;
    }
    if  (!!(ex = aaacipa_getsup(cf, pass))) {
        ifBLIN_QW0("aaacipa_getsup");
        goto out;
    }
    if  (!pass->sess) {
        if  (!!(ex = aaacipa_getins(cf, pass))) {
            ifBLIN_QW0("aaacipa_getins");
            goto out;
        }
        if  (!!(ex = aaacipa_endes(cf, pass->sess, hash))) {
            ifBLIN_QW0("aaacipa_endes");
            goto out;
        }
        if  (!!(ex = aaacipa_gethsh(cf, pass, hash))) {
            ifBLIN_QW0("aaacipa_gethsh");
            goto out;
        }
        if  (!!(ex = aaacipa_getttl(cf, pass))) {
            ifBLIN_QW0("aaacipa_getttl");
            goto out;
    }   }
out:
    ifBLIN_QX2("- %d=%ld~", ex, pass->cred);
    return(ex);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_tabsq(aaacipa_cf *cf, aaacipa_pass *pass, querytype_t querytype) {                         /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    sqlite3_stmt **vvm ;
    sqlite3_stmt  *vm  ;
    FILE          *of  = NULL;
    aaacipa_dbh   *db  = (aaacipa_dbh *)cf->dbhandler;
    int            ex  = EX_OK;
    int            i   ;

    switch(querytype) {
    case qrydel:
        vm = db->vmdel;
        vvm = &db->vmdel;
        break;
    case qrypas:
        /* FALLTHROUGH */
    case qrypasc:
        vm = db->vmpas;
        vvm = &db->vmpas;
        break;
    case qryses:
        /* FALLTHROUGH */
    case qrysesc:
        vm = db->vmses;
        vvm = &db->vmses;
        break;
    case qryseb:
        /* FALLTHROUGH */
    case qrysebc:
        vm = db->vmseb;
        vvm = &db->vmseb;
        break;
    case qryflo:
        vm = db->vmflo;
        vvm = &db->vmflo;
        break;
    case qryfla:
        vm = db->vmfla;
        vvm = &db->vmfla;
        break;
    case qryslo:
        vm = db->vmslo;
        vvm = &db->vmslo;
        break;
    default:
        ifBLIN_QX0("Illegal query type %02X", querytype);
        ex = EX_PROTOCOL;
        goto out;
    }
    i = 0;
    ifBLIN_QX3("bind vm %d=%s~", i, pass->context);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->context, -1, SQLITE_TRANSIENT))) {
        ex = aaacipa_ce(db, vvm, pass->context, __LINE__, ex, "Could not bind context", i);
        goto out;
    }
    switch(querytype) {
    case qrydel:
        /* FALLTHROUGH */
    case qrypasc:
        /* FALLTHROUGH */
    case qrysesc:
        /* FALLTHROUGH */
    case qrysebc:
        /* FALLTHROUGH */
    case qryflo:
        /* FALLTHROUGH */
    case qryfla:
        /* FALLTHROUGH */
    case qryslo:
        ifBLIN_QX3("bind vm %d=%lu", i, pass->cred);
        if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->cred))) {
            ex = aaacipa_ce(db, vvm, "cred", __LINE__, ex, "Could not bind cred", i);
            goto out;
        }
        break;
    case qryses:
        /* FALLTHROUGH */
    case qryseb:
        /* FALLTHROUGH */
    case qrypas:
        break;
    default:
        ifBLIN_QX0("Illegal query type %02X", querytype);
        ex = EX_PROTOCOL;
        goto out;
    }
    switch(querytype) {
    case qrydel:
        /* FALLTHROUGH */
    case qrysesc:
        /* FALLTHROUGH */
    case qryslo:
        ifBLIN_QX3("bind vm %d=%lu", i, pass->sess);
        if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->sess))) {
            ex = aaacipa_ce(db, vvm, "sess", __LINE__, ex, "Could not bind sess", i);
            goto out;
        }
        break;
    default:
        ifBLIN_QX0("Illegal query type %02X", querytype);
        ex = EX_PROTOCOL;
        goto out;
    }
    switch(querytype) {
    case qrydel:
        /* FALLTHROUGH */
    case qryflo:
        /* FALLTHROUGH */
    case qryfla:
        /* FALLTHROUGH */
    case qryslo:
        break;
    case qrypas:
        /* FALLTHROUGH */
    case qrypasc:
        /* FALLTHROUGH */
    case qryses:
        /* FALLTHROUGH */
    case qrysesc:
        /* FALLTHROUGH */
    case qryseb:
        /* FALLTHROUGH */
    case qrysebc:
        if  (!(of = fdopen(cf->fd, "w"))) {
            ifBLIN_QW0("fdopen %d", cf->fd);
            ex = EX_IOERR;
            goto out;
        }
        break;
    default:
        ifBLIN_QX0("Illegal query type %02X", querytype);
        ex = EX_PROTOCOL;
        goto out;
    }
    for (; ;) {
        const char *sepa;
        char       *txt ;
        const char *o   ;
        int         k   ;

        switch((ex = sqlite3_step(vm))) {
        case SQLITE_ROW:
            i = sqlite3_column_count(vm);
            sepa = "";
            for (k = 0; k < i; k++) {
                if  (SQLITE_NULL == sqlite3_column_type(vm, k)) {
                    fprintf(of, "%s\\N", sepa);
                } else {
                    o = (const char *)sqlite3_column_text(vm, k);
                    if  (!(txt = quote(cf, o))) {
                        ifBLIN_QX0("quote REMOTE_ADDR");
                        ex = EX_DATAERR;
                        errno = EINVAL;
                        goto out;
                    }
                    fprintf(of, "%s%s", sepa, txt);
                    free(txt);
                }
                sepa = "\t";
            }
            fprintf(of, "\n");
            continue;
        case SQLITE_DONE:
            break;
        default:
            ex = aaacipa_ce(db, vvm, "", __LINE__, 0, "", 0);
            goto out;
        }
        break;
    }
    if  (!!(ex = aaacipa_reset(cf, __LINE__, vm))) {
        ifBLIN_QW0("aaacipa_reset");
        goto out;
    }
    if  (!!of) {
        fprintf(of, "\\.\n");
        if  (!!fdclose(of, NULL)) ifBLIN_QW1("fdclose");
    }
    if  (!!close(cf->fd)) ifBLIN_QW1("close");
out:
    ifBLIN_QX2("- %d=%ld~", ex, pass->cred);
    return(ex);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_ucreq(aaacipa_cf *cf, aaacipa_pass *pass) {                                                /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    sqlite3_stmt **vvm ;
    sqlite3_stmt  *vm  ;
    aaacipa_dbh   *db  = (aaacipa_dbh *)cf->dbhandler;
    int            ex  = EX_OK;
    int            i   ;

    vm = db->vmcre;
    vvm = &db->vmcre;
    i = 0;
    ifBLIN_QX3("bind vm %d=%s~", i, pass->context);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->context, -1, SQLITE_TRANSIENT))) {
        ex = aaacipa_ce(db, vvm, pass->context, __LINE__, ex, "Could not bind context", i);
        goto out;
    }
    ifBLIN_QX3("bind vm %d=%s~", i, pass->user);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->user, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->user, __LINE__, ex, "Could not bind user", i);
        goto out;
    }
    ifBLIN_QX3("bind vm %d=%s~", i, pass->password);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->password, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->password, __LINE__, ex, "Could not bind password", i);
        goto out;
    }
    ifBLIN_QX3("bind vm %d=%u", i, pass->pflags);
    if  (!!(ex = sqlite3_bind_int64(vm, ++i, (sqlite3_int64)pass->pflags))) {
        ex = aaacipa_ce(db, vvm, "sess", __LINE__, ex, "Could not bind pflags", i);
        goto out;
    }
    ifBLIN_QX3("bind vm %d=%s~", i, pass->nick);
    if  (!!(ex = sqlite3_bind_text(vm, ++i, pass->nick, -1, SQLITE_STATIC))) {
        ex = aaacipa_ce(db, vvm, pass->nick, __LINE__, ex, "Could not bind nick", i);
        goto out;
    }
    switch((ex = sqlite3_step(vm))) {
    case SQLITE_ROW:
        ifBLIN_QX0("Why row IN qcre?");
        aaacipa_fini(db, NULL);
        ex = EX_SOFTWARE;
        errno = E2BIG;
        goto out;
    case SQLITE_DONE:
        if  (!(pass->cred = (int64_t)sqlite3_last_insert_rowid(db->odf))) {
            ifBLIN_QX0("NO cre");
            aaacipa_fini(db, NULL);
            ex = EX_SOFTWARE;
            errno = EDOOFUS;
            goto out;
        }
        ex = EX_OK;
        break;
    default:
        ex = aaacipa_ce(db, vvm, "No ins", __LINE__, 0, "", 0);
        goto out;
    }
    if  (!!(ex = aaacipa_reset(cf, __LINE__, vm))) {
        ifBLIN_QW0("aaacipa_reset");
        goto out;
    }
out:
    pass->errnom = errno;
    ifBLIN_QX2("- %d=%ld errno=%d", ex, pass->cred, pass->errnom);
    return(ex);
#   undef blin_internal_flags
}
