/*-
 * Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: err.c,v 1.2 2024/02/11 20:36:18 babolo Exp $"

#define BLIN_COMPAT      4
#define MIFE_COMPAT      5
#define AAACIPA_INTERNAL 1

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
#if defined(USEBDB)
# include <dbsql.h>
#elif defined(USESQLITE3)
# include <sqlite3.h>
#elif defined(USESQLITE2)
# include <sqlite.h>
#endif
#include <openssl/des.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "aaacipa.h"

#define AAACIPA_FIN(V, S)                                                                                \
    do {                                                                                              \
        if  (!!(V) && !!(exx = sqlite3_finalize(V))) {                                                \
            ifBLIN_QX0("Could not finalize "S": %s(%d)", aaacipa_exdeco(exx), exx);                   \
        }                                                                                             \
        V = NULL;                                                                                     \
        if  (!ex) ex = exx;                                                                           \
    } while(0)

const char *
/*****************************************************************************************************
 **                                                                                                 **/
aaacipa_exdeco(int ex) {                                                                           /**
 **                                                                                                 **
 *****************************************************************************************************/
    const char *c;
    switch (ex) {
    case SQLITE_OK                     : c = "SQLITE_OK";                      break;
    case SQLITE_ERROR                  : c = "SQLITE_ERROR";                   break;
    case SQLITE_INTERNAL               : c = "SQLITE_INTERNAL";                break;
    case SQLITE_PERM                   : c = "SQLITE_PERM";                    break;
    case SQLITE_ABORT                  : c = "SQLITE_ABORT";                   break;
    case SQLITE_BUSY                   : c = "SQLITE_BUSY";                    break;
    case SQLITE_LOCKED                 : c = "SQLITE_LOCKED";                  break;
    case SQLITE_NOMEM                  : c = "SQLITE_NOMEM";                   break;
    case SQLITE_READONLY               : c = "SQLITE_READONLY";                break;
    case SQLITE_INTERRUPT              : c = "SQLITE_INTERRUPT";               break;
    case SQLITE_IOERR                  : c = "SQLITE_IOERR";                   break;
    case SQLITE_CORRUPT                : c = "SQLITE_CORRUPT";                 break;
    case SQLITE_NOTFOUND               : c = "SQLITE_NOTFOUND";                break;
    case SQLITE_FULL                   : c = "SQLITE_FULL";                    break;
    case SQLITE_CANTOPEN               : c = "SQLITE_CANTOPEN";                break;
    case SQLITE_PROTOCOL               : c = "SQLITE_PROTOCOL";                break;
    case SQLITE_EMPTY                  : c = "SQLITE_EMPTY";                   break;
    case SQLITE_SCHEMA                 : c = "SQLITE_SCHEMA";                  break;
    case SQLITE_TOOBIG                 : c = "SQLITE_TOOBIG";                  break;
    case SQLITE_CONSTRAINT             : c = "SQLITE_CONSTRAINT";              break;
    case SQLITE_MISMATCH               : c = "SQLITE_MISMATCH";                break;
    case SQLITE_MISUSE                 : c = "SQLITE_MISUSE";                  break;
    case SQLITE_NOLFS                  : c = "SQLITE_NOLFS";                   break;
    case SQLITE_AUTH                   : c = "SQLITE_AUTH";                    break;
    case SQLITE_FORMAT                 : c = "SQLITE_FORMAT";                  break;
    case SQLITE_RANGE                  : c = "SQLITE_RANGE";                   break;
    case SQLITE_NOTADB                 : c = "SQLITE_NOTADB";                  break;
    case SQLITE_NOTICE                 : c = "SQLITE_NOTICE";                  break;
    case SQLITE_WARNING                : c = "SQLITE_WARNING";                 break;
    case SQLITE_ROW                    : c = "SQLITE_ROW";                     break;
    case SQLITE_DONE                   : c = "SQLITE_DONE";                    break;
#ifdef SQLITE_ERROR_MISSING_COLLSEQ
    case SQLITE_ERROR_MISSING_COLLSEQ  : c = "SQLITE_ERROR_MISSING_COLLSEQ";   break;
#endif
#ifdef SQLITE_ERROR_RETRY
    case SQLITE_ERROR_RETRY            : c = "SQLITE_ERROR_RETRY";             break;
#endif
    case SQLITE_IOERR_READ             : c = "SQLITE_IOERR_READ";              break;
    case SQLITE_IOERR_SHORT_READ       : c = "SQLITE_IOERR_SHORT_READ";        break;
    case SQLITE_IOERR_WRITE            : c = "SQLITE_IOERR_WRITE";             break;
    case SQLITE_IOERR_FSYNC            : c = "SQLITE_IOERR_FSYNC";             break;
    case SQLITE_IOERR_DIR_FSYNC        : c = "SQLITE_IOERR_DIR_FSYNC";         break;
    case SQLITE_IOERR_TRUNCATE         : c = "SQLITE_IOERR_TRUNCATE";          break;
    case SQLITE_IOERR_FSTAT            : c = "SQLITE_IOERR_FSTAT";             break;
    case SQLITE_IOERR_UNLOCK           : c = "SQLITE_IOERR_UNLOCK";            break;
    case SQLITE_IOERR_RDLOCK           : c = "SQLITE_IOERR_RDLOCK";            break;
    case SQLITE_IOERR_DELETE           : c = "SQLITE_IOERR_DELETE";            break;
    case SQLITE_IOERR_BLOCKED          : c = "SQLITE_IOERR_BLOCKED";           break;
    case SQLITE_IOERR_NOMEM            : c = "SQLITE_IOERR_NOMEM";             break;
    case SQLITE_IOERR_ACCESS           : c = "SQLITE_IOERR_ACCESS";            break;
    case SQLITE_IOERR_CHECKRESERVEDLOCK: c = "SQLITE_IOERR_CHECKRESERVEDLOCK"; break;
    case SQLITE_IOERR_LOCK             : c = "SQLITE_IOERR_LOCK";              break;
    case SQLITE_IOERR_CLOSE            : c = "SQLITE_IOERR_CLOSE";             break;
    case SQLITE_IOERR_DIR_CLOSE        : c = "SQLITE_IOERR_DIR_CLOSE";         break;
    case SQLITE_IOERR_SHMOPEN          : c = "SQLITE_IOERR_SHMOPEN";           break;
    case SQLITE_IOERR_SHMSIZE          : c = "SQLITE_IOERR_SHMSIZE";           break;
    case SQLITE_IOERR_SHMLOCK          : c = "SQLITE_IOERR_SHMLOCK";           break;
    case SQLITE_IOERR_SHMMAP           : c = "SQLITE_IOERR_SHMMAP";            break;
    case SQLITE_IOERR_SEEK             : c = "SQLITE_IOERR_SEEK";              break;
    case SQLITE_IOERR_DELETE_NOENT     : c = "SQLITE_IOERR_DELETE_NOENT";      break;
    case SQLITE_IOERR_MMAP             : c = "SQLITE_IOERR_MMAP";              break;
    case SQLITE_IOERR_GETTEMPPATH      : c = "SQLITE_IOERR_GETTEMPPATH";       break;
    case SQLITE_IOERR_CONVPATH         : c = "SQLITE_IOERR_CONVPATH";          break;
#ifdef SQLITE_IOERR_VNODE
    case SQLITE_IOERR_VNODE            : c = "SQLITE_IOERR_VNODE";             break;
#endif
#ifdef SQLITE_IOERR_AUTH
    case SQLITE_IOERR_AUTH             : c = "SQLITE_IOERR_AUTH";              break;
#endif
#ifdef SQLITE_IOERR_BEGIN_ATOMIC
    case SQLITE_IOERR_BEGIN_ATOMIC     : c = "SQLITE_IOERR_BEGIN_ATOMIC";      break;
#endif
#ifdef SQLITE_IOERR_COMMIT_ATOMIC
    case SQLITE_IOERR_COMMIT_ATOMIC    : c = "SQLITE_IOERR_COMMIT_ATOMIC";     break;
#endif
#ifdef SQLITE_IOERR_ROLLBACK_ATOMIC
    case SQLITE_IOERR_ROLLBACK_ATOMIC  : c = "SQLITE_IOERR_ROLLBACK_ATOMIC";   break;
#endif
#ifdef SQLITE_LOCKED_SHAREDCACHE
    case SQLITE_LOCKED_SHAREDCACHE     : c = "SQLITE_LOCKED_SHAREDCACHE";      break;
#endif
#ifdef SQLITE_BUSY_RECOVERY
    case SQLITE_BUSY_RECOVERY          : c = "SQLITE_BUSY_RECOVERY";           break;
#endif
#ifdef SQLITE_BUSY_SNAPSHOT
    case SQLITE_BUSY_SNAPSHOT          : c = "SQLITE_BUSY_SNAPSHOT";           break;
#endif
#ifdef SQLITE_CANTOPEN_NOTEMPDIR
    case SQLITE_CANTOPEN_NOTEMPDIR     : c = "SQLITE_CANTOPEN_NOTEMPDIR";      break;
#endif
#ifdef SQLITE_CANTOPEN_ISDIR
    case SQLITE_CANTOPEN_ISDIR         : c = "SQLITE_CANTOPEN_ISDIR";          break;
#endif
#ifdef SQLITE_CANTOPEN_FULLPATH
    case SQLITE_CANTOPEN_FULLPATH      : c = "SQLITE_CANTOPEN_FULLPATH";       break;
#endif
#ifdef SQLITE_CANTOPEN_CONVPATH
    case SQLITE_CANTOPEN_CONVPATH      : c = "SQLITE_CANTOPEN_CONVPATH";       break;
#endif
#ifdef SQLITE_CORRUPT_VTAB
    case SQLITE_CORRUPT_VTAB           : c = "SQLITE_CORRUPT_VTAB";            break;
#endif
#ifdef SQLITE_READONLY_RECOVERY
    case SQLITE_READONLY_RECOVERY      : c = "SQLITE_READONLY_RECOVERY";       break;
#endif
#ifdef SQLITE_READONLY_CANTLOCK
    case SQLITE_READONLY_CANTLOCK      : c = "SQLITE_READONLY_CANTLOCK";       break;
#endif
#ifdef SQLITE_READONLY_ROLLBACK
    case SQLITE_READONLY_ROLLBACK      : c = "SQLITE_READONLY_ROLLBACK";       break;
#endif
#ifdef SQLITE_READONLY_DBMOVED
    case SQLITE_READONLY_DBMOVED       : c = "SQLITE_READONLY_DBMOVED";        break;
#endif
#ifdef SQLITE_READONLY_CANTINIT
    case SQLITE_READONLY_CANTINIT      : c = "SQLITE_READONLY_CANTINIT";       break;
#endif
#ifdef SQLITE_READONLY_DIRECTORY
    case SQLITE_READONLY_DIRECTORY     : c = "SQLITE_READONLY_DIRECTORY";      break;
#endif
#ifdef SQLITE_ABORT_ROLLBACK
    case SQLITE_ABORT_ROLLBACK         : c = "SQLITE_ABORT_ROLLBACK";          break;
#endif
#ifdef SQLITE_CONSTRAINT_CHECK
    case SQLITE_CONSTRAINT_CHECK       : c = "SQLITE_CONSTRAINT_CHECK";        break;
#endif
#ifdef SQLITE_CONSTRAINT_COMMITHOOK
    case SQLITE_CONSTRAINT_COMMITHOOK  : c = "SQLITE_CONSTRAINT_COMMITHOOK";   break;
#endif
#ifdef SQLITE_CONSTRAINT_FOREIGNKEY
    case SQLITE_CONSTRAINT_FOREIGNKEY  : c = "SQLITE_CONSTRAINT_FOREIGNKEY";   break;
#endif
#ifdef SQLITE_CONSTRAINT_FUNCTION
    case SQLITE_CONSTRAINT_FUNCTION    : c = "SQLITE_CONSTRAINT_FUNCTION";     break;
#endif
#ifdef SQLITE_CONSTRAINT_NOTNULL
    case SQLITE_CONSTRAINT_NOTNULL     : c = "SQLITE_CONSTRAINT_NOTNULL";      break;
#endif
#ifdef SQLITE_CONSTRAINT_PRIMARYKEY
    case SQLITE_CONSTRAINT_PRIMARYKEY  : c = "SQLITE_CONSTRAINT_PRIMARYKEY";   break;
#endif
#ifdef SQLITE_CONSTRAINT_TRIGGER
    case SQLITE_CONSTRAINT_TRIGGER     : c = "SQLITE_CONSTRAINT_TRIGGER";      break;
#endif
#ifdef SQLITE_CONSTRAINT_UNIQUE
    case SQLITE_CONSTRAINT_UNIQUE      : c = "SQLITE_CONSTRAINT_UNIQUE";       break;
#endif
#ifdef SQLITE_CONSTRAINT_VTAB
    case SQLITE_CONSTRAINT_VTAB        : c = "SQLITE_CONSTRAINT_VTAB";         break;
#endif
#ifdef SQLITE_CONSTRAINT_ROWID
    case SQLITE_CONSTRAINT_ROWID       : c = "SQLITE_CONSTRAINT_ROWID";        break;
#endif
#ifdef SQLITE_NOTICE_RECOVER_WAL
    case SQLITE_NOTICE_RECOVER_WAL     : c = "SQLITE_NOTICE_RECOVER_WAL";      break;
#endif
#ifdef SQLITE_NOTICE_RECOVER_ROLLBACK
    case SQLITE_NOTICE_RECOVER_ROLLBACK: c = "SQLITE_NOTICE_RECOVER_ROLLBACK"; break;
#endif
#ifdef SQLITE_WARNING_AUTOINDEX
    case SQLITE_WARNING_AUTOINDEX      : c = "SQLITE_WARNING_AUTOINDEX";       break;
#endif
#ifdef SQLITE_AUTH_USER
    case SQLITE_AUTH_USER              : c = "SQLITE_AUTH_USER";               break;
#endif
#ifdef SQLITE_OK_LOAD_PERMANENTLY
    case SQLITE_OK_LOAD_PERMANENTLY    : c = "SQLITE_OK_LOAD_PERMANENTLY";     break;
#endif
    default                            :
        if  (ex & ~0xFF) c = aaacipa_exdeco(ex & 0xFF); else c = "UNKNOWN";
    }
    return(c);
}

int
/*****************************************************************************************************
 **                                                                                                 **/
aaacipa_fini(aaacipa_dbh *db, sqlite3_stmt **vm) {                                                 /**
 **                                                                                                 **
 *****************************************************************************************************/            
    int exx = EX_OK;
    int ex  = EX_OK;

    ifBLIN_QX2("+ %"BLIN_X, BLIN_I(vm));
    if  (!!vm) AAACIPA_FIN(*vm, "vm");
    AAACIPA_FIN(db->vmprm, "vmprm");
    AAACIPA_FIN(db->vmaaa, "vmaaa");
    AAACIPA_FIN(db->vmttl, "vmttl");
    AAACIPA_FIN(db->vmsup, "vmsup");
    AAACIPA_FIN(db->vmins, "vmins");
    AAACIPA_FIN(db->vmhsh, "vmhsh");
    if  (!!(exx = sqlite3_close(db->odf))) {
        ifBLIN_QX0("Could not close: %s(%d)", aaacipa_exdeco(exx), exx);
    }
    db->odf = NULL;
    if  (!ex) ex = exx;
    if  (!!(exx = sqlite3_shutdown())) {
        ifBLIN_QX0("Could not shutdown: %s(%d)", aaacipa_exdeco(exx), exx);
    }
    if  (!ex) ex = exx;
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 **                                                                                                 **/
aaacipa_ce( aaacipa_dbh   *db                                                                      /**/
          , sqlite3_stmt **vm                                                                      /**/
          , const char    *c                                                                       /**/
          , int            ln                                                                      /**/
          , int            ex                                                                      /**/
          , const char    *er                                                                      /**/
          , int            i                                                                       /**/
          ) {                                                                                      /**
 **                                                                                                 **
 *****************************************************************************************************/
    if  (!ex) {
        ifBLIN_QX0("%s @%d: %s", er, ln, c);
    } else {
        if  (!i) {
            ifBLIN_QX0("%s @%d: %s(%d): %s", er, ln, aaacipa_exdeco(ex), ex, c);
        } else {
            ifBLIN_QX0("%s[%d] @%d: %s(%d): %s", er, i, ln, aaacipa_exdeco(ex), ex, c);
        }
        i = -1;
#if 0   /* Not defined in BDB */
        i = sqlite3_error_offset(db->odf);
#endif
        if  (0 <= i) {
            ifBLIN_QX0(": @%d %s", i, sqlite3_errmsg(db->odf));
        } else {
            ifBLIN_QX0(": %s", sqlite3_errmsg(db->odf));
    }   }
    if  (!!vm) {
        if  (!!*vm && !!(ex = sqlite3_reset(*vm))) {
            ifBLIN_QX0("Could not reset @%d: %s(%d)", ln, aaacipa_exdeco(ex), ex);
        }
        *vm = NULL;
    }
    if  (!!(ex = aaacipa_fini(db, vm))) {
        ifBLIN_QX0("aaacipa_fini @%d: %s(%d)", ln, aaacipa_exdeco(ex), ex);
    }
    errno = ECANCELED;
    return(EX_SOFTWARE);
}
