/*-
 * Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ident "@(#) Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/"
#ident "@(#) $Id: des.c,v 1.12 2024/03/03 19:43:05 babolo Exp $"

#define BLIN_COMPAT      4
#define MIFE_COMPAT      5

#include <sys/types.h>
#include <sys/event.h>
#include <sys/time.h>
#include <sysexits.h>
#include <strings.h>
#include <string.h>
#include <errno.h>
#include <openssl/des.h>
#include <babolo/BLINflag.h>
#include <mife.h>
#include "aaacipa.h"

u_char const aaacipa_set[] = "0123456789ABCDEFHIJKLMNPRTUVWXYZabcdefghijkmnopqrstuvwxyz";

int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_prep(aaacipa_cf *cf) {                                                                     /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    u_int64_t reo = 0; /* To silence warning, no real need */
    int       ex  = EX_OK;

    ifBLIN_QX2("+ %016lX %016lX", cf->key, cf->iv);
    DES_set_odd_parity(&cf->k);
    DES_set_odd_parity(&cf->ivec);
    switch(DES_set_key_checked(&cf->k, &cf->schedule)) {
    case -1:
        ifBLIN_QX0("the parity is wrong");
        ex = EX_DATAERR;
        errno = EINVAL;
        goto out;
    case -2:
        ifBLIN_QX0("the key is a weak key");
        ex = EX_CONFIG;
        errno = EFTYPE;
        goto out;
    }
    for (u_int64_t u = AAACIPA_HBASE; !!u;) {
        u_int64_t k  ;
        u_int64_t n  ;

        ifBLIN_QX3("%lu", u);
        switch(u) {
        case AAACIPA_HBASE: reo = cf->vector[4]; break;
        case 56   : reo = cf->vector[3]; break;
        case 45   : reo = cf->vector[2]; break;
        case 33   : reo = cf->vector[1]; break;
        case 20   : reo = cf->vector[0]; break;
        }
        k = reo % u;
        ifBLIN_QX4("%016lX %lu %lu", reo, k, u);
        reo /= u;
        for (n = 0; n <= k; n++) if (!!cf->enco[n]) k++;
        cf->enco[k] = aaacipa_set[--u];
        ifBLIN_QX4( "%016lX %lu "
                    "%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c"
                    "%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c"
                  , reo
                  , k
                  , cf->enco[ 0] ? cf->enco[ 0] : '.'
                  , cf->enco[ 1] ? cf->enco[ 1] : '.'
                  , cf->enco[ 2] ? cf->enco[ 2] : '.'
                  , cf->enco[ 3] ? cf->enco[ 3] : '.'
                  , cf->enco[ 4] ? cf->enco[ 4] : '.'
                  , cf->enco[ 5] ? cf->enco[ 5] : '.'
                  , cf->enco[ 6] ? cf->enco[ 6] : '.'
                  , cf->enco[ 7] ? cf->enco[ 7] : '.'
                  , cf->enco[ 8] ? cf->enco[ 8] : '.'
                  , cf->enco[ 9] ? cf->enco[ 9] : '.'
                  , cf->enco[10] ? cf->enco[10] : '.'
                  , cf->enco[11] ? cf->enco[11] : '.'
                  , cf->enco[12] ? cf->enco[12] : '.'
                  , cf->enco[13] ? cf->enco[13] : '.'
                  , cf->enco[14] ? cf->enco[14] : '.'
                  , cf->enco[15] ? cf->enco[15] : '.'
                  , cf->enco[16] ? cf->enco[16] : '.'
                  , cf->enco[17] ? cf->enco[17] : '.'
                  , cf->enco[18] ? cf->enco[18] : '.'
                  , cf->enco[19] ? cf->enco[19] : '.'
                  , cf->enco[20] ? cf->enco[20] : '.'
                  , cf->enco[21] ? cf->enco[21] : '.'
                  , cf->enco[22] ? cf->enco[22] : '.'
                  , cf->enco[23] ? cf->enco[23] : '.'
                  , cf->enco[24] ? cf->enco[24] : '.'
                  , cf->enco[25] ? cf->enco[25] : '.'
                  , cf->enco[26] ? cf->enco[26] : '.'
                  , cf->enco[27] ? cf->enco[27] : '.'
                  , cf->enco[28] ? cf->enco[28] : '.'
                  , cf->enco[29] ? cf->enco[29] : '.'
                  , cf->enco[30] ? cf->enco[30] : '.'
                  , cf->enco[31] ? cf->enco[31] : '.'
                  , cf->enco[32] ? cf->enco[32] : '.'
                  , cf->enco[33] ? cf->enco[33] : '.'
                  , cf->enco[34] ? cf->enco[34] : '.'
                  , cf->enco[35] ? cf->enco[35] : '.'
                  , cf->enco[36] ? cf->enco[36] : '.'
                  , cf->enco[37] ? cf->enco[37] : '.'
                  , cf->enco[38] ? cf->enco[38] : '.'
                  , cf->enco[39] ? cf->enco[39] : '.'
                  , cf->enco[40] ? cf->enco[40] : '.'
                  , cf->enco[41] ? cf->enco[41] : '.'
                  , cf->enco[42] ? cf->enco[42] : '.'
                  , cf->enco[43] ? cf->enco[43] : '.'
                  , cf->enco[44] ? cf->enco[44] : '.'
                  , cf->enco[45] ? cf->enco[45] : '.'
                  , cf->enco[46] ? cf->enco[46] : '.'
                  , cf->enco[47] ? cf->enco[47] : '.'
                  , cf->enco[48] ? cf->enco[48] : '.'
                  , cf->enco[49] ? cf->enco[49] : '.'
                  , cf->enco[50] ? cf->enco[50] : '.'
                  , cf->enco[51] ? cf->enco[51] : '.'
                  , cf->enco[52] ? cf->enco[52] : '.'
                  , cf->enco[53] ? cf->enco[53] : '.'
                  , cf->enco[54] ? cf->enco[54] : '.'
                  , cf->enco[55] ? cf->enco[55] : '.'
                  , cf->enco[56] ? cf->enco[56] : '.'
                  );
    }
    for (int i = 0; i < 128; ++i) cf->deco[i] = (int8_t)0xFF;
    for (int i = 0; i < AAACIPA_HBASE; ++i) cf->deco[cf->enco[i]] = (int8_t)i;
    cf->deco['Q'] = cf->deco['O'] = cf->deco['0'];
    cf->deco['l'] = cf->deco['1'];
    cf->deco['G'] = cf->deco['C'];
    cf->deco['S'] = cf->deco['5'];
    ifBLIN_QO3 blin_dumb(3, cf->deco, 128);
    reo = cf->vector[4] / AAACIPA_HBASE;
    for (u_int8_t u = AAACIPA_HLEN; !!u;) {
        u_int64_t k  ;
        u_int64_t n  ;

        k = reo % u;
        ifBLIN_QX4("%016lX %lu %hhu", reo, k, u);
        reo /= u;
        for (n = 0; n <= k; n++) if (!!cf->reord[n]) k++;
        cf->reord[k] = --u;
        ifBLIN_QX4( "%016lX %lu %X%X%X%X%X%X%X%X%X%X%X"
                  , reo
                  , k
                  , cf->reord[ 0]
                  , cf->reord[ 1]
                  , cf->reord[ 2]
                  , cf->reord[ 3]
                  , cf->reord[ 4]
                  , cf->reord[ 5]
                  , cf->reord[ 6]
                  , cf->reord[ 7]
                  , cf->reord[ 8]
                  , cf->reord[ 9]
                  , cf->reord[10]
                  );
    }
out:
    ifBLIN_QX2("- %d", ex);
    return(ex);
#   undef blin_internal_flags
}

static u_int64_t
/*****************************************************************************************************
 **                                                                                                 **/
aaacipa_des(aaacipa_cf *cf, u_int64_t in, int enc) {                                               /**
 **                                                                                                 **
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    DES_key_schedule  sched;
    u_int64_t         res  = 0;
    DES_cblock        ivec ;

    ifBLIN_QX2("+ %d %016lX", enc, in);
    bcopy(&cf->schedule, &sched, sizeof(sched));
    bcopy(&cf->ivec, &ivec, sizeof(ivec));
    DES_ncbc_encrypt((u_char *)&in, (u_char *)&res, 8, &cf->schedule, &ivec, enc);
    ifBLIN_QX2("- %016lX", res);
    return(res);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_dedes(aaacipa_cf *cf, u_int64_t *sess, char hash[AAACIPA_HLEN + 1]) {                      /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    int        ex = EX_OK;
    u_int64_t  hs ;
    u_int64_t  m  ;

    ifBLIN_QX2("+ %s", hash);
    if  (AAACIPA_HLEN != strlen(hash)) {
        ifBLIN_QX0("[%zd]%s",strlen(hash) , hash);
        ex = EX_NOINPUT;
        errno = ENOENT;
        goto out;
    }
    hs = 0;
    m = 1;
    for (int i = 0; i < AAACIPA_HLEN; ++i, m *= AAACIPA_HBASE) {
        if  (128 <= (hash[cf->reord[i]] & 0x0FF)) {
            ifBLIN_QX0("%d %u %X", i, cf->reord[i], hash[cf->reord[i]]);
            ex = EX_PROTOCOL;
            errno = EDOM;
            goto out;
        }
        if  (0 > cf->deco[hash[cf->reord[i]] & 0x0FF]) {
            ifBLIN_QX0( "%d %u %X %d"
                      , i
                      , cf->reord[i]
                      , hash[cf->reord[i]]
                      , cf->deco[hash[cf->reord[i]] & 0x0FF]
                      );
            ex = EX_DATAERR;
            errno = EINVAL;
            goto out;
        }
        hs += m * (u_int64_t)cf->deco[hash[cf->reord[i]] & 0x0FF];
    }
    *sess = aaacipa_des(cf, hs, 0);
out:
    ifBLIN_QX2("- %d %016lX", ex, *sess);
    return(ex);
#   undef blin_internal_flags
}

int
/*****************************************************************************************************
 *****************************************************************************************************
 **                                                                                                 **/
aaacipa_endes(aaacipa_cf *cf, u_int64_t sess, char hash[AAACIPA_HLEN + 1]) {                       /**
 **                                                                                                 **
 *****************************************************************************************************
 *****************************************************************************************************/
#   define blin_internal_flags (cf->flags & BLIN_MASK)
    int        ex = EX_OK;
    u_int64_t  hs ;

    ifBLIN_QX2("+ %016lX", sess);
    hs = aaacipa_des(cf, sess, 1);
    for (int i = 0; i < AAACIPA_HLEN; ++i) {
        hash[cf->reord[i]] = (char)cf->enco[hs % AAACIPA_HBASE];
        hs /= AAACIPA_HBASE;
    }
    hash[AAACIPA_HLEN] = '\0';
    ifBLIN_QX2("- %d %s", ex, hash);
    return(ex);
#   undef blin_internal_flags
}
