/*-
 * Copyright (C)2023..2024 @BABOLO http://www.babolo.ru/
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: aaacipa.h,v 1.33 2024/05/26 18:45:15 babolo Exp $
 *
 * (AAACIPA_HBASE ** AAACIPA_HLEN) > (2 ** 64)
 */

#define AAACIPA_MAXQSZ  255      /*     AAA    */
#define AAACIPA_HBASE   57       /*                         */
#define AAACIPA_HLEN    11       /*           */
#define AAACIPA_NICKLEN 63       /*                               */
#define AAACIPA_MAXCRED (offsetof(aaacipa_pass, nick) + 1)
                                 /*    AAA     */
#define AAACIPA_CRELEN  ((ssize_t)(2 * sizeof(int32_t) + sizeof(int64_t)))
                                 /*    CRE                  */
#define SessClaimPass    1       /*                         */
#define SessAuthName     2       /*    AuthName                    */
#define PassToSess      15       /*   sess                          */
#define PassClaimPass   16       /*                         */
#define PassAuthName    32       /*    AuthName                    */
#define CredReadPost    64       /*                            */
#define CredAdmin      128       /*                                       */
#define PostToRede       1       /*                           */


typedef struct addrinfo addrinfo;

typedef struct {
    char         pid[8];
} aaacipa_pid;

typedef enum
{   qryaaa  =  0
,   qrydel  =  1
,   qrypas  =  2
,   qrypasc =  3
,   qryses  =  4
,   qrysesc =  5
,   qryseb  =  6
,   qrysebc =  7
,   qryflo  =  8
,   qryfla  =  9
,   qryslo  = 10
,   qrycre  = 11
} querytype_t;

typedef struct {
    size_t     q    ;              /*    .query       */
    size_t     p    ;              /*    .query */
    char       query[AAACIPA_MAXQSZ + 1];
} querystr;

typedef struct {
    u_char     type   [4];
    u_int32_t  flags  ;
    int64_t    cred   ;
    u_int64_t  sess   ;
    char       context[AAACIPA_MAXQSZ + 1];
} querytabs_t;

typedef struct {
    BLIN_flag         flags       ;                /*                                           */
# define  AAACIPA_NODEMON 0x000100 /*            */
# define  AAACIPA_LOCAL   0x000200 /*                */
# define  AAACIPA_CFILE   0x000400 /*      */
    pid_t             pid         ;                /* PID                                            */
    union {
        u_int64_t     key  ;                       /*                                 */
        DES_cblock    k    ;
    };
    union {
        u_int64_t     iv   ;                       /*                         */
        DES_cblock    ivec ;
    };
    DES_key_schedule  schedule    ;                /*                         */
    u_int64_t         vector      [5];             /*                              */
    const char       *pidf        ;                /*  pid                                   */
    addrinfo         *ai          ;                /* addrinfo                                  */
    const char       *conf        ;                /*                                    */
    const char       *host        ;                /*   bind                                 */
    const char       *cport       ;                /*                     */
    const char       *dbfile      ;                /*                                        */
    const char       *passwd      ;                /*                      ****/
    const char       *cipaconf    ;                /*                ****/
    const char       *sessions    ;                /*                     ****/
    const char       *sessionb    ;                /*                ****/
    const char       *fieldcred   ;                /*      (  sessions)   */
    const char       *fieldcontext;                /*                        */
    const char       *fieldlogin  ;                /*     (  sessions)        */
    const char       *fieldpass   ;                /*     (  sessions)        */
    const char       *fieldsrcip  ;                /*    IP                             */
    const char       *fieldttl    ;                /*    TTL (  sessions, cipaconf)  */
    const char       *fieldreo    ;                /*  5           */
    const char       *fieldkey    ;                /*                         */
    const char       *fieldvinit  ;                /*          */
    const char       *fieldsess   ;                /*                      */
    const char       *fieldhash   ;                /*                        */
    const char       *fieldcnt    ;                /*                   */
    const char       *fieldsessip ;                /*    src IP                   */
    const char       *fieldflags  ;                /*                            */
    const char       *fieldcreat  ;                /*                   */
    const char       *fieldupdt   ;                /*              */
    const char       *fieldmzone  ;                /*                 */
    const char       *fieldnick   ;                /*                              */
    const char       *fieldpflags ;                /*                       */
    const char       *fieldsflags ;                /*                       */
    const char       *fieldremark ;                /*                          */
    const char       *fieldcre    ;                /*             */
    const char       *fieldupd    ;                /*           */
    const char       *fielddel    ;                /*             */
    void             *dbhandler   ;                /*                               */
    aaacipa_pid      *pidp        ;                /*    pid                    */
    mife_descriptor  *md          ;                /*                             */
    double            ttl         ;                /*                     */
    int               confd       ;                /*                           */
    int               pidd        ;                /*   pid                   */
    int               bd          ;                /*                       */
    int               fd          ;                /*                     */
    int               curdir      ;                /* ,                */
    int               dummy0      ;
    u_int16_t         port        ;                /*                            */
    int8_t            deco        [128];
    u_int8_t          enco        [AAACIPA_HBASE];
    u_int8_t          reord       [AAACIPA_HLEN];
    u_int16_t         dummy       ;
} aaacipa_cf;

typedef struct {
    int64_t         cred    ;
    union {
        u_int64_t   sess    ;
        struct {
            int32_t ex      ;
            int32_t errnom  ;
    };  };
    u_int32_t       pflags  ;
    u_int32_t       sflags  ;
    char            hash    [AAACIPA_HLEN + 1];
    int32_t         mzone   ;
    double          ttl     ;                      /*                                */
    char            nick    [AAACIPA_NICKLEN + 1];
    double          now     ;
    double          back    ;
    char           *password;
    char           *context ;
    char           *request ;
    char           *srcip   ;
    char           *user    ;
    char           *cheme   ;
    querystr        query   ;
    int8_t          crypt   ;
    int8_t          dummy2  ;
    int16_t         dummy3  ;
    int32_t         dummy4  ;
} aaacipa_pass;

extern u_char const aaacipa_set[];

int         aaacipa_cook   __P((aaacipa_cf *cf)); /* For SQL */
int         aaacipa_prep   __P((aaacipa_cf *cf)); /* For DES */
int         aaacipa_passq  __P((aaacipa_cf *cf, aaacipa_pass *pass));
int         aaacipa_ucreq  __P((aaacipa_cf *cf, aaacipa_pass *pass));
int         aaacipa_tabsq  __P((aaacipa_cf *cf, aaacipa_pass *pass, querytype_t querytype));
int         aaacipa_dedes  __P((aaacipa_cf *cf, u_int64_t *sess, char *hash));
int         aaacipa_endes  __P((aaacipa_cf *cf, u_int64_t sess, char *hash));

#ifdef AAACIPA_INTERNAL

typedef struct {
    sqlite3      *odf;
    sqlite3_stmt *vmprm;
    sqlite3_stmt *vmaaa;
    sqlite3_stmt *vmttl;
    sqlite3_stmt *vmsup;
    sqlite3_stmt *vmins;
    sqlite3_stmt *vmhsh;
    sqlite3_stmt *vmdel;
    sqlite3_stmt *vmpas;
    sqlite3_stmt *vmses;
    sqlite3_stmt *vmseb;
    sqlite3_stmt *vmflo;
    sqlite3_stmt *vmfla;
    sqlite3_stmt *vmslo;
    sqlite3_stmt *vmcre;
} aaacipa_dbh;

int         aaacipa_ce     __P(( aaacipa_dbh   *db
                               , sqlite3_stmt **vm
                               , const char    *c
                               , int            ln
                               , int            ex
                               , const char    *er
                               , int            i
                              ));
const char *aaacipa_exdeco __P((int ex));
int         aaacipa_fini   __P((aaacipa_dbh *db, sqlite3_stmt **vm));

#endif
